"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.shouldShowInstallationStatus = exports.getLineClampStyles = exports.InstallationStatus = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _css = require("@emotion/css");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _constants = require("../../../../../../common/constants");
var _compressed_installation_status = require("./compressed_installation_status");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/components/installation_status.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const installedLabel = _i18n.i18n.translate('xpack.fleet.packageCard.installedLabel', {
  defaultMessage: 'Installed'
});
const installedTooltip = _i18n.i18n.translate('xpack.fleet.packageCard.installedTooltip', {
  defaultMessage: 'This package is installed but no data streams exist.'
});
const installFailedTooltip = _i18n.i18n.translate('xpack.fleet.packageCard.installFailedTooltip', {
  defaultMessage: 'This package is installed but failed.'
});
const activeLabel = _i18n.i18n.translate('xpack.fleet.packageCard.activeLabel', {
  defaultMessage: 'Active'
});
const getCalloutText = ({
  installStatus,
  isActive
}) => {
  if (isActive) {
    return {
      color: 'success',
      iconType: 'check',
      title: activeLabel
    };
  }
  if (installStatus === _constants.installationStatuses.Installed || installStatus === _constants.installationStatuses.InstallFailed) {
    return {
      color: 'warning',
      iconType: 'warning',
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        "data-test-subj": "installed-tooltip",
        position: "bottom",
        content: installStatus === _constants.installationStatuses.Installed ? installedTooltip : installFailedTooltip,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 76,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        tabIndex: 0,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 85,
          columnNumber: 11
        }
      }, installedLabel))
    };
  }
  return {};
};
const useInstallationStatusStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isDarkMode = (0, _reactKibanaContextTheme.useKibanaIsDarkMode)();
  return _react.default.useMemo(() => ({
    installationStatus: (0, _css.css)`
        position: absolute;
        border-radius: 0 0 ${euiTheme.border.radius.medium} ${euiTheme.border.radius.medium};
        bottom: 0;
        left: 0;
        width: 100%;
        overflow: hidden;
      `,
    compressedInstallationStatus: (0, _css.css)`
        position: absolute;
        border-radius: 0 ${euiTheme.border.radius.medium} ${euiTheme.border.radius.medium} 0;
        bottom: 0;
        right: 0;
        width: 65px;
        overflow: hidden;
        display: flex;
        justify-content: center;
        align-items: center;
        height: 100%;
      `,
    compressedInstalledStatus: (0, _css.css)`
        background-color: ${isDarkMode ? euiTheme.colors.warning : euiTheme.colors.backgroundBaseWarning};
      `,
    compressedActiveStatus: (0, _css.css)`
        background-color: ${isDarkMode ? euiTheme.colors.success : euiTheme.colors.backgroundBaseSuccess};
      `,
    compressedInstalledStatusIcon: (0, _css.css)`
        color: ${isDarkMode ? euiTheme.colors.emptyShade : euiTheme.colors.textWarning};
      `,
    compressedActiveStatusIcon: (0, _css.css)`
        color: ${isDarkMode ? euiTheme.colors.emptyShade : euiTheme.colors.textSuccess};
      `,
    installedCallout: (0, _css.css)`
        padding: ${euiTheme.size.s} ${euiTheme.size.m};
        text-align: center;
      `,
    installedSpacer: (0, _css.css)`
        background: ${euiTheme.colors.emptyShade};
      `
  }), [euiTheme, isDarkMode]);
};
const getLineClampStyles = lineClamp => lineClamp ? `-webkit-line-clamp: ${lineClamp};display: -webkit-box;-webkit-box-orient: vertical;overflow: hidden;` : '';
exports.getLineClampStyles = getLineClampStyles;
const shouldShowInstallationStatus = ({
  installStatus,
  isActive,
  showInstallationStatus
}) => {
  const installedStatus = installStatus === _constants.installationStatuses.Installed || installStatus === _constants.installationStatuses.InstallFailed;
  return showInstallationStatus && (isActive || installedStatus);
};
exports.shouldShowInstallationStatus = shouldShowInstallationStatus;
const InstallationStatus = exports.InstallationStatus = /*#__PURE__*/_react.default.memo(({
  installStatus,
  showInstallationStatus,
  compressed,
  hasDataStreams: isActive
}) => {
  const styles = useInstallationStatusStyles();
  if (!shouldShowInstallationStatus({
    installStatus,
    showInstallationStatus,
    isActive
  })) {
    return null;
  }
  return compressed ? /*#__PURE__*/_react.default.createElement(_compressed_installation_status.CompressedInstallationStatus, {
    installStatus: installStatus,
    isActive: isActive,
    installedTooltip: installedTooltip,
    installFailedTooltip: installFailedTooltip,
    styles: styles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 7
    }
  }) : /*#__PURE__*/_react.default.createElement("div", {
    className: styles.installationStatus,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    "data-test-subj": "installation-status-spacer",
    size: "m",
    className: styles.installedSpacer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, (0, _extends2.default)({
    "data-test-subj": "installation-status-callout",
    className: styles.installedCallout
  }, getCalloutText({
    installStatus,
    isActive
  }), {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 9
    }
  })));
});