"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SettingsApp = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _hooks = require("../../hooks");
var _constants = require("../../constants");
var _layouts = require("../../layouts");
var _components = require("../../components");
var _constants2 = require("../../../../../common/constants");
var _settings_page = require("./components/settings_page");
var _use_confirm_modal = require("./hooks/use_confirm_modal");
var _fleet_server_hosts_flyout = require("./components/fleet_server_hosts_flyout");
var _hooks2 = require("./hooks");
var _download_source_flyout = require("./components/download_source_flyout");
var _use_delete_download_source = require("./components/download_source_flyout/use_delete_download_source");
var _edit_fleet_proxy_flyout = require("./components/edit_fleet_proxy_flyout");
var _edit_output_flyout = require("./components/edit_output_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/settings/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function useSettingsAppData() {
  const outputs = (0, _hooks.useGetOutputs)();
  const fleetServerHosts = (0, _hooks.useGetFleetServerHosts)();
  const downloadSources = (0, _hooks.useGetDownloadSources)();
  const proxies = (0, _hooks.useGetFleetProxies)();
  return {
    outputs,
    fleetServerHosts,
    downloadSources,
    proxies
  };
}
const SettingsApp = exports.SettingsApp = (0, _use_confirm_modal.withConfirmModalProvider)(() => {
  var _outputs$data, _fleetServerHosts$dat, _downloadSources$data, _proxies$data, _proxies$data$items2, _proxies$data3, _fleetServerHosts$dat2, _outputs$data2, _proxies$data6;
  (0, _hooks.useBreadcrumbs)('settings');
  const history = (0, _reactRouterDom.useHistory)();
  const flyoutContext = (0, _hooks.useFlyoutContext)();
  const {
    outputs,
    fleetServerHosts,
    downloadSources,
    proxies
  } = useSettingsAppData();
  const outputItems = (_outputs$data = outputs.data) === null || _outputs$data === void 0 ? void 0 : _outputs$data.items.filter(item => !item.is_internal);
  const fleetServerHostsItems = (_fleetServerHosts$dat = fleetServerHosts.data) === null || _fleetServerHosts$dat === void 0 ? void 0 : _fleetServerHosts$dat.items.filter(item => !item.is_internal);
  const {
    deleteOutput
  } = (0, _hooks2.useDeleteOutput)(outputs.resendRequest);
  const {
    deleteDownloadSource
  } = (0, _use_delete_download_source.useDeleteDownloadSource)(downloadSources.resendRequest);
  const {
    deleteFleetServerHost
  } = (0, _hooks2.useDeleteFleetServerHost)(fleetServerHosts.resendRequest);
  const {
    deleteFleetProxy
  } = (0, _hooks2.useDeleteProxy)(proxies.resendRequest);
  const resendOutputRequest = outputs.resendRequest;
  const resendDownloadSourceRequest = downloadSources.resendRequest;
  const resendFleetServerHostsRequest = fleetServerHosts.resendRequest;
  const resendProxiesRequest = proxies.resendRequest;
  const onCloseCallback = (0, _react.useCallback)(() => {
    flyoutContext.closeFleetServerFlyout();
    resendOutputRequest();
    resendDownloadSourceRequest();
    resendFleetServerHostsRequest();
    resendProxiesRequest();
    history.replace(_constants.pagePathGetters.settings()[1]);
  }, [flyoutContext, resendOutputRequest, resendDownloadSourceRequest, resendFleetServerHostsRequest, resendProxiesRequest, history]);
  const {
    cloud
  } = (0, _hooks.useStartServices)();
  const isServerlessEnabled = cloud === null || cloud === void 0 ? void 0 : cloud.isServerlessEnabled;
  if (outputs.isLoading && outputs.isInitialRequest || !outputItems || fleetServerHosts.isLoading && fleetServerHosts.isInitialRequest || !fleetServerHostsItems || downloadSources.isLoading && downloadSources.isInitialRequest || !((_downloadSources$data = downloadSources.data) !== null && _downloadSources$data !== void 0 && _downloadSources$data.items) || proxies.isLoading && proxies.isInitialRequest || !((_proxies$data = proxies.data) !== null && _proxies$data !== void 0 && _proxies$data.items)) {
    return /*#__PURE__*/_react.default.createElement(_layouts.DefaultLayout, {
      section: "settings",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_components.Loading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_layouts.DefaultLayout, {
    section: "settings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.settings_edit_fleet_server_hosts,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  }, route => {
    var _proxies$data$items, _proxies$data2;
    const fleetServerHost = fleetServerHostsItems.find(o => {
      var _route$match;
      return ((_route$match = route.match) === null || _route$match === void 0 ? void 0 : _route$match.params.itemId) === o.id;
    });
    if (!fleetServerHost) {
      return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
        to: _constants.FLEET_ROUTING_PATHS.settings,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 115,
          columnNumber: 22
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_fleet_server_hosts_flyout.FleetServerHostsFlyout, {
      proxies: (_proxies$data$items = (_proxies$data2 = proxies.data) === null || _proxies$data2 === void 0 ? void 0 : _proxies$data2.items) !== null && _proxies$data$items !== void 0 ? _proxies$data$items : [],
      onClose: onCloseCallback,
      fleetServerHost: fleetServerHost,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 17
      }
    }));
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.settings_create_fleet_server_hosts,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 11
    }
  }, isServerlessEnabled ? /*#__PURE__*/_react.default.createElement(_fleet_server_hosts_flyout.FleetServerHostsFlyout, {
    proxies: (_proxies$data$items2 = (_proxies$data3 = proxies.data) === null || _proxies$data3 === void 0 ? void 0 : _proxies$data3.items) !== null && _proxies$data$items2 !== void 0 ? _proxies$data$items2 : [],
    onClose: onCloseCallback,
    defaultFleetServerHost: (_fleetServerHosts$dat2 = fleetServerHosts.data) === null || _fleetServerHosts$dat2 === void 0 ? void 0 : _fleetServerHosts$dat2.items.find(o => o.id === _constants2.SERVERLESS_DEFAULT_FLEET_SERVER_HOST_ID),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_components.FleetServerFlyout, {
    onClose: onCloseCallback,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.settings_create_outputs,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_edit_output_flyout.EditOutputFlyout, {
    proxies: proxies.data.items,
    onClose: onCloseCallback,
    defaultOutput: isServerlessEnabled ? (_outputs$data2 = outputs.data) === null || _outputs$data2 === void 0 ? void 0 : _outputs$data2.items.find(o => o.id === _constants2.SERVERLESS_DEFAULT_OUTPUT_ID) : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.settings_create_fleet_proxy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_edit_fleet_proxy_flyout.FleetProxyFlyout, {
    onClose: onCloseCallback,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.settings_edit_fleet_proxy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 9
    }
  }, route => {
    var _proxies$data4;
    const fleetProxy = (_proxies$data4 = proxies.data) === null || _proxies$data4 === void 0 ? void 0 : _proxies$data4.items.find(item => {
      var _route$match2;
      return ((_route$match2 = route.match) === null || _route$match2 === void 0 ? void 0 : _route$match2.params.itemId) === item.id;
    });
    if (!fleetProxy) {
      return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
        to: _constants.FLEET_ROUTING_PATHS.settings,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 168,
          columnNumber: 22
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_edit_fleet_proxy_flyout.FleetProxyFlyout, {
      onClose: onCloseCallback,
      fleetProxy: fleetProxy,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 17
      }
    }));
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.settings_edit_outputs,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 9
    }
  }, route => {
    var _proxies$data$items3, _proxies$data5, _outputs$data3;
    const output = outputItems.find(o => {
      var _route$match3;
      return ((_route$match3 = route.match) === null || _route$match3 === void 0 ? void 0 : _route$match3.params.outputId) === o.id;
    });
    if (!output) {
      return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
        to: _constants.FLEET_ROUTING_PATHS.settings,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 181,
          columnNumber: 22
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 185,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_edit_output_flyout.EditOutputFlyout, {
      proxies: (_proxies$data$items3 = (_proxies$data5 = proxies.data) === null || _proxies$data5 === void 0 ? void 0 : _proxies$data5.items) !== null && _proxies$data$items3 !== void 0 ? _proxies$data$items3 : [],
      onClose: onCloseCallback,
      output: output,
      defaultOutput: isServerlessEnabled ? (_outputs$data3 = outputs.data) === null || _outputs$data3 === void 0 ? void 0 : _outputs$data3.items.find(o => o.id === _constants2.SERVERLESS_DEFAULT_OUTPUT_ID) : undefined,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 17
      }
    }));
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.settings_create_download_sources,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_download_source_flyout.EditDownloadSourceFlyout, {
    onClose: onCloseCallback,
    proxies: (proxies === null || proxies === void 0 ? void 0 : (_proxies$data6 = proxies.data) === null || _proxies$data6 === void 0 ? void 0 : _proxies$data6.items) || [],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.settings_edit_download_sources,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 9
    }
  }, route => {
    var _downloadSources$data2, _proxies$data7;
    const downloadSource = (_downloadSources$data2 = downloadSources.data) === null || _downloadSources$data2 === void 0 ? void 0 : _downloadSources$data2.items.find(o => {
      var _route$match4;
      return ((_route$match4 = route.match) === null || _route$match4 === void 0 ? void 0 : _route$match4.params.downloadSourceId) === o.id;
    });
    if (!downloadSource) {
      return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
        to: _constants.FLEET_ROUTING_PATHS.settings,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 214,
          columnNumber: 22
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 218,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_download_source_flyout.EditDownloadSourceFlyout, {
      onClose: onCloseCallback,
      downloadSource: downloadSource,
      proxies: (proxies === null || proxies === void 0 ? void 0 : (_proxies$data7 = proxies.data) === null || _proxies$data7 === void 0 ? void 0 : _proxies$data7.items) || [],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 219,
        columnNumber: 17
      }
    }));
  })), /*#__PURE__*/_react.default.createElement(_settings_page.SettingsPage, {
    deleteFleetProxy: deleteFleetProxy,
    proxies: proxies.data.items,
    outputs: outputItems,
    fleetServerHosts: fleetServerHostsItems,
    deleteOutput: deleteOutput,
    deleteFleetServerHost: deleteFleetServerHost,
    downloadSources: downloadSources.data.items,
    deleteDownloadSource: deleteDownloadSource,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 7
    }
  }));
});