"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FleetServerHostsFlyout = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _multi_row_input = require("../multi_row_input");
var _constants = require("../../../../constants");
var _hooks = require("../../../../hooks");
var _form = require("../form");
var _proxy_warning = require("../fleet_proxies_table/proxy_warning");
var _services = require("../../../../services");
var _ssl_form_section = require("./ssl_form_section");
var _use_fleet_server_host_form = require("./use_fleet_server_host_form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/settings/components/fleet_server_hosts_flyout/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FleetServerHostsFlyout = ({
  onClose,
  fleetServerHost,
  defaultFleetServerHost,
  proxies
}) => {
  var _inputs$proxyIdInput, _inputs$proxyIdInput3, _inputs$proxyIdInput5;
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    docLinks,
    cloud
  } = (0, _hooks.useStartServices)();
  const form = (0, _use_fleet_server_host_form.useFleetServerHostsForm)(fleetServerHost, onClose, defaultFleetServerHost);
  const {
    inputs
  } = form;
  const proxiesOptions = (0, _react.useMemo)(() => proxies.map(proxy => ({
    value: proxy.id,
    label: proxy.name
  })), [proxies]);
  const {
    enableSSLSecrets
  } = _services.ExperimentalFeaturesService.get();
  const [isFirstLoad, setIsFirstLoad] = _react.default.useState(true);
  const [isConvertedToSecret, setIsConvertedToSecret] = _react.default.useState({
    sslKey: false,
    sslESKey: false
  });
  const [secretsToggleState, setSecretsToggleState] = (0, _react.useState)(true);
  const useSecretsStorage = secretsToggleState === true;
  const fleetStatus = (0, _hooks.useFleetStatus)();
  if (fleetStatus.isSecretsStorageEnabled !== undefined && secretsToggleState === 'disabled') {
    setSecretsToggleState(fleetStatus.isSecretsStorageEnabled);
  }
  const onToggleSecretStorage = secretEnabled => {
    if (secretsToggleState === 'disabled') {
      return;
    }
    setSecretsToggleState(secretEnabled);
  };
  (0, _react.useEffect)(() => {
    if (!isFirstLoad) return;
    setIsFirstLoad(false);
    // populate the secret input with the value of the plain input in order to re-save the key with secret storage
    if (useSecretsStorage && enableSSLSecrets) {
      if (inputs.sslKeyInput.value && !inputs.sslKeySecretInput.value) {
        inputs.sslKeySecretInput.setValue(inputs.sslKeyInput.value);
        inputs.sslKeyInput.clear();
        setIsConvertedToSecret({
          ...isConvertedToSecret,
          sslKey: true
        });
      }
      if (inputs.sslESKeyInput.value && !inputs.sslESKeySecretInput.value) {
        inputs.sslESKeySecretInput.setValue(inputs.sslESKeyInput.value);
        inputs.sslESKeyInput.clear();
        setIsConvertedToSecret({
          ...isConvertedToSecret,
          sslESKey: true
        });
      }
    }
  }, [inputs.sslKeyInput, inputs.sslKeySecretInput, isFirstLoad, setIsFirstLoad, isConvertedToSecret, inputs.sslESKeyInput, inputs.sslESKeySecretInput, secretsToggleState, useSecretsStorage, enableSSLSecrets]);
  const onToggleSecretAndClearValue = secretEnabled => {
    if (secretEnabled) {
      inputs.sslKeyInput.clear();
      inputs.sslESKeyInput.clear();
    } else {
      inputs.sslKeySecretInput.setValue('');
      inputs.sslESKeySecretInput.setValue('');
    }
    setIsConvertedToSecret({
      ...isConvertedToSecret,
      sslKey: false,
      sslESKey: false
    });
    onToggleSecretStorage(secretEnabled);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    maxWidth: _constants.MAX_FLYOUT_WIDTH,
    "aria-labelledby": modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 13
    }
  }, fleetServerHost ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.fleetServerHostsFlyout.editTitle",
    defaultMessage: "Edit Fleet Server",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.fleetServerHostsFlyout.addTitle",
    defaultMessage: "Add Fleet Server",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 17
    }
  }))), !fleetServerHost && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.fleetServerHostsFlyout.serverlessInfoText",
    defaultMessage: "You may create another Fleet Server definition reachable via a proxy. In context of the serverless project, Fleet Service is managed by Elastic. Creation of a new one is therefore not permitted.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 17
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 7
    }
  }, fleetServerHost && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "m",
    color: "warning",
    iconType: "warning",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.fleetServerHostsFlyout.warningCalloutTitle",
      defaultMessage: "Changing these settings can break your agent connections",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.fleetServerHostsFlyout.warningCalloutDescription",
    defaultMessage: "Invalid settings can break the connection between Elastic Agent and Fleet Server. If this happens, you will need to re-enroll your agents.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    onSubmit: form.submit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_form.TextInput, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.fleetServerHostsFlyout.nameInputLabel",
      defaultMessage: "Name",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 188,
        columnNumber: 15
      }
    }),
    inputProps: inputs.nameInput,
    dataTestSubj: "fleetServerHostsFlyout.nameInput",
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHostsFlyout.nameInputPlaceholder', {
      defaultMessage: 'Specify name'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.fleetServerHostsFlyout.hostUrlLabel",
      defaultMessage: "URL",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 203,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !(cloud !== null && cloud !== void 0 && cloud.isServerlessEnabled) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "relative",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.fleetServerHostsFlyout.description",
    defaultMessage: "Specify multiple URLs to scale out your deployment and provide automatic failover. If multiple URLs exist, Fleet shows the first provided URL for enrollment purposes. Enrolled Elastic Agents will connect to the URLs in round robin order until they connect successfully. For more information, see the {link} .",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.settingsFleetServerHostSettings,
        target: "_blank",
        external: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 218,
          columnNumber: 27
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.settings.fleetServerHostsFlyout.userGuideLink",
        defaultMessage: "Fleet and Elastic Agent Guide",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 223,
          columnNumber: 29
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_multi_row_input.MultiRowInput, (0, _extends2.default)({}, inputs.hostUrlsInput.props, {
    id: "fleet-server-inputs",
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHostsFlyout.fleetServerHostsInputPlaceholder', {
      defaultMessage: 'Specify host URL'
    }),
    isUrl: true,
    helpText: (cloud === null || cloud === void 0 ? void 0 : cloud.isServerlessEnabled) && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.fleetServerHostsFlyout.serverlessHostUrlsHelpText",
      defaultMessage: "Custom host URLs are not allowed in serverless.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 247,
        columnNumber: 21
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.fleetServerHostsFlyout.proxyIdLabel",
      defaultMessage: "Proxy",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 259,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({
    fullWidth: true,
    "data-test-subj": "fleetServerHostsFlyout.proxyIdInput"
  }, (_inputs$proxyIdInput = inputs.proxyIdInput) === null || _inputs$proxyIdInput === void 0 ? void 0 : _inputs$proxyIdInput.props, {
    onChange: options => {
      var _inputs$proxyIdInput2, _options$0$value, _options$;
      return inputs === null || inputs === void 0 ? void 0 : (_inputs$proxyIdInput2 = inputs.proxyIdInput) === null || _inputs$proxyIdInput2 === void 0 ? void 0 : _inputs$proxyIdInput2.setValue((_options$0$value = options === null || options === void 0 ? void 0 : (_options$ = options[0]) === null || _options$ === void 0 ? void 0 : _options$.value) !== null && _options$0$value !== void 0 ? _options$0$value : '');
    },
    selectedOptions: (inputs === null || inputs === void 0 ? void 0 : (_inputs$proxyIdInput3 = inputs.proxyIdInput) === null || _inputs$proxyIdInput3 === void 0 ? void 0 : _inputs$proxyIdInput3.value) !== '' ? proxiesOptions.filter(option => {
      var _inputs$proxyIdInput4;
      return option.value === ((_inputs$proxyIdInput4 = inputs.proxyIdInput) === null || _inputs$proxyIdInput4 === void 0 ? void 0 : _inputs$proxyIdInput4.value);
    }) : [],
    options: proxiesOptions,
    singleSelection: {
      asPlainText: true
    },
    isDisabled: (_inputs$proxyIdInput5 = inputs.proxyIdInput) === null || _inputs$proxyIdInput5 === void 0 ? void 0 : _inputs$proxyIdInput5.props.disabled,
    isClearable: true,
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHostsFlyout.proxyIdPlaceholder', {
      defaultMessage: 'Select proxy'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 287,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_proxy_warning.ProxyWarning, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true
  }, inputs.isDefaultInput.formRowProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 291,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, (0, _extends2.default)({
    "data-test-subj": "fleetServerHostsFlyout.isDefaultSwitch"
  }, inputs.isDefaultInput.props, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.fleetServerHostsFlyout.defaultOutputSwitchLabel",
      defaultMessage: "Make this Fleet server the default one.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 296,
        columnNumber: 17
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 292,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 303,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_ssl_form_section.SSLFormSection, {
    inputs: inputs,
    useSecretsStorage: enableSSLSecrets && useSecretsStorage,
    onToggleSecretAndClearValue: onToggleSecretAndClearValue,
    isConvertedToSecret: isConvertedToSecret,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 312,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 314,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => onClose(),
    flush: "left",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 315,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.fleetServerHostsFlyout.cancelButtonLabel",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 316,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 322,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    isLoading: form.isLoading,
    isDisabled: form.isDisabled,
    onClick: form.submit,
    "data-test-subj": "saveApplySettingsBtn",
    "aria-label": "Save and apply settings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 323,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.fleetServerHostsFlyout.saveButton",
    defaultMessage: "Save and apply settings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 15
    }
  }))))));
};
exports.FleetServerHostsFlyout = FleetServerHostsFlyout;