"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.YamlCodeEditorWithPlaceholder = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _codeEditor = require("@kbn/code-editor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/settings/components/edit_output_flyout/yaml_code_editor_with_placeholder.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CodeEditorContainer = _styledComponents.default.div`
  min-height: 0;
  position: relative;
  height: 116px;
`;
const CodeEditorPlaceholder = (0, _styledComponents.default)(_eui.EuiTextColor).attrs(props => ({
  color: 'subdued',
  size: 'xs'
}))`
  position: absolute;
  top: 0;
  left: 0;
  // Matches monaco editor
  font-family: Menlo, Monaco, 'Courier New', monospace;
  font-size: 12px;
  line-height: 21px;
  pointer-events: none;
`;
const CODE_EDITOR_OPTIONS = {
  minimap: {
    enabled: false
  },
  ariaLabel: _i18n.i18n.translate('xpack.fleet.settings.yamlCodeEditor', {
    defaultMessage: 'YAML Code Editor'
  }),
  scrollBeyondLastLine: false,
  wordWrap: 'on',
  wrappingIndent: 'indent',
  automaticLayout: true,
  tabSize: 2,
  // To avoid left margin
  lineNumbers: 'off',
  lineNumbersMinChars: 0,
  glyphMargin: false,
  folding: false,
  lineDecorationsWidth: 0
};
const YamlCodeEditorWithPlaceholder = props => {
  const {
    placeholder,
    disabled,
    ...editorProps
  } = props;
  if (disabled) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      style: {
        height: '116px'
      },
      language: "yaml",
      isCopyable: false,
      paddingSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("pre", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 9
      }
    }, editorProps.value));
  }
  return /*#__PURE__*/_react.default.createElement(CodeEditorContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, (0, _extends2.default)({
    languageId: "yaml",
    width: "100%",
    height: "116px",
    options: CODE_EDITOR_OPTIONS
  }, editorProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  })), (!editorProps.value || editorProps.value === '') && /*#__PURE__*/_react.default.createElement(CodeEditorPlaceholder, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 9
    }
  }, placeholder));
};
exports.YamlCodeEditorWithPlaceholder = YamlCodeEditorWithPlaceholder;