"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DownloadSourceTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/settings/components/download_source_table/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NameFlexItemWithMaxWidth = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  max-width: 250px;
`;

// Allow child to be truncated
const FlexGroupWithMinWidth = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  min-width: 0px;
`;
const DownloadSourceTable = ({
  downloadSources,
  deleteDownloadSource,
  hasAllSettingsPrivileges
}) => {
  const {
    getHref
  } = (0, _hooks.useLink)();
  const columns = (0, _react.useMemo)(() => {
    return [{
      render: downloadSource => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 43,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(NameFlexItemWithMaxWidth, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 44,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        title: downloadSource.name,
        className: `eui-textTruncate`,
        "data-test-subj": "editDownloadSourceTable.name",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 45,
          columnNumber: 15
        }
      }, downloadSource.name))),
      width: '288px',
      name: _i18n.i18n.translate('xpack.fleet.settings.downloadSourcesTable.nameColumnTitle', {
        defaultMessage: 'Name'
      })
    }, {
      truncateText: true,
      render: downloadSource => /*#__PURE__*/_react.default.createElement(FlexGroupWithMinWidth, {
        direction: "column",
        gutterSize: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 63,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: downloadSource.host,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 64,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        title: downloadSource.host,
        className: `eui-textTruncate`,
        "data-test-subj": "editDownloadSourceTable.host",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 65,
          columnNumber: 15
        }
      }, downloadSource.host))),
      name: _i18n.i18n.translate('xpack.fleet.settings.downloadSourcesTable.hostColumnTitle', {
        defaultMessage: 'Host'
      })
    }, {
      render: downloadSource => downloadSource.is_default ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "check",
        "data-test-subj": "editDownloadSourceTable.defaultIcon",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 82,
          columnNumber: 13
        }
      }) : null,
      width: '200px',
      name: _i18n.i18n.translate('xpack.fleet.settings.downloadSourcesTable.defaultColumnTitle', {
        defaultMessage: 'Default'
      })
    }, {
      width: '68px',
      render: downloadSource => {
        const isDeleteVisible = !downloadSource.is_default && hasAllSettingsPrivileges;
        const deleteDownloadSourceLabel = _i18n.i18n.translate('xpack.fleet.settings.downloadSourceSection.deleteButtonTitle', {
          defaultMessage: 'Delete'
        });
        const editDownloadSourceLabel = _i18n.i18n.translate('xpack.fleet.settings.downloadSourceSection.editButtonTitle', {
          defaultMessage: 'Edit'
        });
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s",
          justifyContent: "flexEnd",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 107,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 108,
            columnNumber: 15
          }
        }, isDeleteVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
          "aria-label": deleteDownloadSourceLabel,
          color: "text",
          iconType: "trash",
          onClick: () => deleteDownloadSource(downloadSource),
          title: deleteDownloadSourceLabel,
          "data-test-subj": "editDownloadSourceTable.delete.btn",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 110,
            columnNumber: 19
          }
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 120,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
          "aria-label": editDownloadSourceLabel,
          color: "text",
          iconType: "pencil",
          href: getHref('settings_edit_download_sources', {
            downloadSourceId: downloadSource.id
          }),
          title: editDownloadSourceLabel,
          "data-test-subj": "editDownloadSourceTable.edit.btn",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 121,
            columnNumber: 17
          }
        })));
      },
      name: _i18n.i18n.translate('xpack.fleet.settings.downloadSourceSection.actionsColumnTitle', {
        defaultMessage: 'Actions'
      })
    }];
  }, [deleteDownloadSource, getHref, hasAllSettingsPrivileges]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: columns,
    items: downloadSources,
    "data-test-subj": "AgentDownloadSourcesTable",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 5
    }
  });
};
exports.DownloadSourceTable = DownloadSourceTable;