"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UninstallTokenListPage = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _empty_policy_name_hint = require("../../../../../components/uninstall_command_flyout/empty_policy_name_hint");
var _api_key_field = require("../../../../../components/api_key_field");
var _uninstall_tokens = require("../../../../../hooks/use_request/uninstall_tokens");
var _hooks = require("../../../hooks");
var _layouts = require("../../../layouts");
var _components = require("../../../components");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/uninstall_token_list_page/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TextField = ({
  text,
  dataTestSubj
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  className: "eui-textTruncate",
  title: text,
  "data-test-subj": dataTestSubj,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 44,
    columnNumber: 3
  }
}, text);
const ViewUninstallCommandButton = ({
  onClick
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  content: _translations.VIEW_UNINSTALL_COMMAND_LABEL,
  disableScreenReaderOutput: true,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 50,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
  "data-test-subj": "uninstallTokensViewCommandButton",
  "aria-label": _translations.VIEW_UNINSTALL_COMMAND_LABEL,
  onClick: onClick,
  iconType: "inspect",
  color: "text",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 51,
    columnNumber: 5
  }
}));
const NoItemsMessage = ({
  isLoading
}) => isLoading ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.uninstallTokenList.loadingTokensMessage",
  defaultMessage: "Loading uninstall tokens...",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 63,
    columnNumber: 5
  }
}) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.uninstallTokenList.emptyMessage",
  defaultMessage: "No uninstall tokens found.",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 68,
    columnNumber: 5
  }
});
const UninstallTokenListPage = () => {
  var _data$items, _data$total;
  (0, _hooks.useBreadcrumbs)('uninstall_tokens');
  const [policyIdOrNameSearch, setPolicyIdOrNameSearch] = (0, _react.useState)('');
  const [tokenIdForFlyout, setTokenIdForFlyout] = (0, _react.useState)(null);
  const {
    pagination,
    setPagination,
    pageSizeOptions
  } = (0, _hooks.usePagination)();
  const {
    isLoading,
    data
  } = (0, _uninstall_tokens.useGetUninstallTokens)({
    perPage: pagination.pageSize,
    page: pagination.currentPage,
    search: policyIdOrNameSearch
  });
  const tokens = (_data$items = data === null || data === void 0 ? void 0 : data.items) !== null && _data$items !== void 0 ? _data$items : [];
  const total = (_data$total = data === null || data === void 0 ? void 0 : data.total) !== null && _data$total !== void 0 ? _data$total : 0;
  const columns = (0, _react.useMemo)(() => [{
    field: 'policy_name',
    name: _translations.POLICY_NAME_TITLE,
    render: policyName => {
      if (policyName === null) {
        return /*#__PURE__*/_react.default.createElement(_empty_policy_name_hint.EmptyPolicyNameHint, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 98,
            columnNumber: 20
          }
        });
      } else {
        return /*#__PURE__*/_react.default.createElement(TextField, {
          text: policyName,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 100,
            columnNumber: 20
          }
        });
      }
    }
  }, {
    field: 'policy_id',
    name: _translations.POLICY_ID_TITLE,
    render: policyId => /*#__PURE__*/_react.default.createElement(TextField, {
      text: policyId,
      dataTestSubj: "uninstallTokensPolicyIdField",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 11
      }
    })
  }, {
    field: 'created_at',
    name: _translations.CREATED_AT_TITLE,
    width: '130px',
    render: createdAt => createdAt ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedDate, {
      year: "numeric",
      month: "short",
      day: "2-digit",
      value: createdAt,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 13
      }
    }) : null
  }, {
    field: 'id',
    name: _translations.TOKEN_TITLE,
    width: '300px',
    render: uninstallTokenId => /*#__PURE__*/_react.default.createElement(_api_key_field.ApiKeyField, {
      apiKeyId: uninstallTokenId,
      sendGetAPIKey: _uninstall_tokens.sendGetUninstallToken,
      tokenGetter: response => {
        var _response$data;
        return (_response$data = response.data) === null || _response$data === void 0 ? void 0 : _response$data.item.token;
      },
      length: 32,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 11
      }
    })
  }, {
    field: 'actions',
    name: _translations.ACTIONS_TITLE,
    align: 'center',
    width: '70px',
    render: (_, {
      id
    }) => /*#__PURE__*/_react.default.createElement(ViewUninstallCommandButton, {
      onClick: () => setTokenIdForFlyout(id),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 11
      }
    })
  }], []);
  const handleTablePagination = (0, _react.useCallback)(({
    page
  }) => {
    setPagination(prevPagination => ({
      ...prevPagination,
      currentPage: page.index + 1,
      pageSize: page.size
    }));
  }, [setPagination]);
  const handleSearch = (0, _react.useCallback)(searchString => {
    setPolicyIdOrNameSearch(searchString);
    setPagination(prevPagination => ({
      ...prevPagination,
      currentPage: 1
    }));
  }, [setPagination]);
  return /*#__PURE__*/_react.default.createElement(_layouts.DefaultLayout, {
    section: "uninstall_tokens",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 5
    }
  }, tokenIdForFlyout && /*#__PURE__*/_react.default.createElement(_components.UninstallCommandFlyout, {
    onClose: () => setTokenIdForFlyout(null),
    target: "agent",
    uninstallTokenId: tokenIdForFlyout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.uninstallTokenList.pageDescription",
    defaultMessage: "An uninstall token allows you to use the uninstall command to remove Elastic Agent from a host.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    onSearch: handleSearch,
    incremental: true,
    fullWidth: true,
    maxLength: 50,
    placeholder: _translations.SEARCH_BY_POLICY_ID_OR_NAME_PLACEHOLDER,
    "data-test-subj": "uninstallTokensPolicyIdSearchInput",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _translations.SEARCH_BY_POLICY_ID_OR_NAME_HINT,
    type: "info",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "uninstallTokenListTable",
    items: tokens,
    columns: columns,
    itemId: "id",
    loading: isLoading,
    pagination: {
      pageIndex: pagination.currentPage - 1,
      pageSize: pagination.pageSize,
      totalItemCount: total,
      pageSizeOptions
    },
    onChange: handleTablePagination,
    noItemsMessage: /*#__PURE__*/_react.default.createElement(NoItemsMessage, {
      isLoading: isLoading,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 214,
        columnNumber: 25
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 7
    }
  }));
};
exports.UninstallTokenListPage = UninstallTokenListPage;