"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useScheduleDateTime = useScheduleDateTime;
var _react = require("react");
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useScheduleDateTime(now) {
  const initialDatetime = (0, _react.useMemo)(() => (0, _moment.default)(now), [now]);
  const [startDatetime, setStartDatetime] = (0, _react.useState)(initialDatetime);
  const minTime = (0, _react.useMemo)(() => {
    if (startDatetime.isSame(initialDatetime, 'day')) {
      return initialDatetime.clone();
    }
  }, [startDatetime, initialDatetime]);
  const maxTime = (0, _react.useMemo)(() => {
    if (startDatetime.isSame(initialDatetime, 'day')) {
      return initialDatetime.clone().endOf('day');
    }
  }, [startDatetime, initialDatetime]);
  const onChangeStartDateTime = (0, _react.useCallback)(date => {
    if (!date) {
      return;
    }
    if (date.isBefore(initialDatetime)) {
      setStartDatetime(initialDatetime);
    } else {
      setStartDatetime(date);
    }
  }, [initialDatetime]);
  return {
    startDatetime,
    initialDatetime,
    onChangeStartDateTime,
    minTime,
    maxTime
  };
}