"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeadersInput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/agent_list_page/components/migrate_agent_flyout/headers_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const HeadersInput = ({
  headers,
  onUpdate
}) => {
  const addEmptyHeader = () => {
    onUpdate({
      ...headers,
      '': ''
    });
  };
  const replaceKeyOrValue = (0, _react.useCallback)((index, keyOrValue, updateType) => {
    const entries = Object.entries(headers);
    if (updateType === 'key') {
      const updatedEntries = entries.map((entry, i) => i === index ? [keyOrValue, entry[1]] : entry);
      onUpdate(Object.fromEntries(updatedEntries));
    } else {
      const updatedEntries = entries.map((entry, i) => i === index ? [entry[0], keyOrValue] : entry);
      onUpdate(Object.fromEntries(updatedEntries));
    }
  }, [headers, onUpdate]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, headers && Object.entries(headers).map(([key, value], index) => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 5,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      placeholder: _i18n.i18n.translate('xpack.fleet.agentList.migrateAgentFlyout.headersKeyPlaceholder', {
        defaultMessage: 'Key'
      }),
      onChange: e => {
        replaceKeyOrValue(index, e.target.value, 'key');
      },
      value: key,
      fullWidth: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 5,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: value,
      placeholder: _i18n.i18n.translate('xpack.fleet.agentList.migrateAgentFlyout.headersValuePlaceholder', {
        defaultMessage: 'Value'
      }),
      onChange: e => {
        replaceKeyOrValue(index, e.target.value, 'value');
      },
      fullWidth: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "cross",
      onClick: () => {
        // Get all entries from headers
        const entries = Object.entries(headers);
        // Filter out the entry at the specified index
        const updatedEntries = entries.filter((_, i) => i !== index);
        // Convert back to object and update the form state
        onUpdate(Object.fromEntries(updatedEntries));
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 19
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 15
      }
    }));
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "plusInCircle",
    onClick: () => {
      addEmptyHeader();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.migrateAgentFlyout.addHeaderLabel",
    defaultMessage: "Add Row",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  }))));
};
exports.HeadersInput = HeadersInput;