"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasetFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../../../hooks");
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/agent_details_page/components/agent_logs/filter_dataset.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DatasetFilter = exports.DatasetFilter = /*#__PURE__*/(0, _react.memo)(({
  selectedDatasets,
  onToggleDataset
}) => {
  const {
    unifiedSearch,
    data
  } = (0, _hooks.useStartServices)();
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [datasetValues, setDatasetValues] = (0, _react.useState)([_constants.AGENT_DATASET]);
  const togglePopover = (0, _react.useCallback)(() => setIsOpen(prevIsOpen => !prevIsOpen), [setIsOpen]);
  const closePopover = (0, _react.useCallback)(() => setIsOpen(false), [setIsOpen]);
  const datasetValuesToOptions = (0, _react.useCallback)(values => {
    return values.map(value => ({
      label: value,
      checked: selectedDatasets.includes(value) ? 'on' : undefined,
      key: value
    }));
  }, [selectedDatasets]);
  const [options, setOptions] = (0, _react.useState)(datasetValuesToOptions(datasetValues));
  (0, _react.useEffect)(() => {
    const fetchValues = async () => {
      setIsLoading(true);
      try {
        const fields = await data.dataViews.getFieldsForWildcard({
          pattern: _constants.AGENT_LOG_INDEX_PATTERN
        });
        const fieldsMap = fields.reduce((acc, curr) => {
          acc[curr.name] = curr;
          return acc;
        }, {});
        const newDataView = await data.dataViews.create({
          title: _constants.AGENT_LOG_INDEX_PATTERN,
          fields: fieldsMap
        });
        const values = await unifiedSearch.autocomplete.getValueSuggestions({
          indexPattern: newDataView,
          field: _constants.DATASET_FIELD,
          query: ''
        });
        if (values.length > 0) {
          setDatasetValues(values.sort());
          setOptions(datasetValuesToOptions(values.sort()));
        }
      } catch (e) {
        setDatasetValues([_constants.AGENT_DATASET]);
        setOptions(datasetValuesToOptions([_constants.AGENT_DATASET]));
      }
      setIsLoading(false);
    };
    fetchValues();
  }, [data.dataViews, unifiedSearch.autocomplete, datasetValuesToOptions]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      "data-test-subj": "agentList.datasetFilterBtn",
      iconType: "arrowDown",
      onClick: togglePopover,
      isSelected: isOpen,
      isLoading: isLoading,
      numFilters: datasetValues.length,
      hasActiveFilters: selectedDatasets.length > 0,
      numActiveFilters: selectedDatasets.length,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.fleet.agentLogs.datasetSelectText', {
      defaultMessage: 'Dataset'
    })),
    isOpen: isOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    options: options,
    onChange: newOptions => {
      setOptions(newOptions);
      newOptions.forEach((option, index) => {
        if (option.checked !== options[index].checked) {
          onToggleDataset(option.label);
          return;
        }
      });
    },
    "data-test-subj": "agentList.datasetFilterOptions",
    isLoading: isLoading,
    listProps: {
      paddingSize: 's',
      style: {
        minWidth: 220
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }, list => list));
});