"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackagePoliciesTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _components = require("../../../../../components");
var _hooks = require("../../../../../hooks");
var _services = require("../../../../../services");
var _otelcol_helpers = require("../../../../../../../../common/services/otelcol_helpers");
var _add_integration_flyout = require("./add_integration_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/details_page/components/package_policies/package_policies_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const stringSortAscending = (a, b) => a.localeCompare(b);
const toFilterOption = value => ({
  name: value,
  value
});
const PackagePoliciesTable = ({
  packagePolicies: originalPackagePolicies,
  agentPolicy,
  refreshAgentPolicy,
  ...rest
}) => {
  var _permissionCheck$data, _permissionCheck$data2;
  const authz = (0, _hooks.useAuthz)();
  const canWriteIntegrationPolicies = authz.integrations.writeIntegrationPolicies;
  const canReadAgentPolicies = authz.fleet.readAgentPolicies;
  const canReadIntegrationPolicies = authz.integrations.readIntegrationPolicies;
  const {
    isPackagePolicyUpgradable
  } = (0, _hooks.useIsPackagePolicyUpgradable)();
  const {
    getHref
  } = (0, _hooks.useLink)();
  const {
    canUseMultipleAgentPolicies
  } = (0, _hooks.useMultipleAgentPolicies)();
  const [showAddIntegrationFlyout, setShowAddIntegrationFlyout] = _react.default.useState(false);
  const {
    enableOtelIntegrations
  } = _services.ExperimentalFeaturesService.get();
  const permissionCheck = (0, _hooks.usePermissionCheck)();
  const missingSecurityConfiguration = !((_permissionCheck$data = permissionCheck.data) !== null && _permissionCheck$data !== void 0 && _permissionCheck$data.success) && ((_permissionCheck$data2 = permissionCheck.data) === null || _permissionCheck$data2 === void 0 ? void 0 : _permissionCheck$data2.error) === 'MISSING_SECURITY';

  // With the package policies provided on input, generate the list of package policies
  // used in the InMemoryTable (flattens some values for search) as well as
  // the list of options that will be used in the filters dropdowns
  const [packagePolicies, namespaces] = (0, _react.useMemo)(() => {
    const namespacesValues = new Set();
    const mappedPackagePolicies = originalPackagePolicies.map(packagePolicy => {
      var _packagePolicy$packag, _packagePolicy$packag2, _packagePolicy$packag3, _packagePolicy$packag4, _packagePolicy$packag5, _packagePolicy$packag6;
      if (packagePolicy.namespace) {
        namespacesValues.add(packagePolicy.namespace);
      }
      const hasUpgrade = isPackagePolicyUpgradable(packagePolicy);
      return {
        ...packagePolicy,
        packageName: (_packagePolicy$packag = (_packagePolicy$packag2 = packagePolicy.package) === null || _packagePolicy$packag2 === void 0 ? void 0 : _packagePolicy$packag2.name) !== null && _packagePolicy$packag !== void 0 ? _packagePolicy$packag : '',
        packageTitle: (_packagePolicy$packag3 = (_packagePolicy$packag4 = packagePolicy.package) === null || _packagePolicy$packag4 === void 0 ? void 0 : _packagePolicy$packag4.title) !== null && _packagePolicy$packag3 !== void 0 ? _packagePolicy$packag3 : '',
        packageVersion: (_packagePolicy$packag5 = (_packagePolicy$packag6 = packagePolicy.package) === null || _packagePolicy$packag6 === void 0 ? void 0 : _packagePolicy$packag6.version) !== null && _packagePolicy$packag5 !== void 0 ? _packagePolicy$packag5 : '',
        hasUpgrade
      };
    });
    const namespaceFilterOptions = [...namespacesValues].sort(stringSortAscending).map(toFilterOption);
    return [mappedPackagePolicies, namespaceFilterOptions];
  }, [originalPackagePolicies, isPackagePolicyUpgradable]);
  const getSharedPoliciesNumber = (0, _react.useCallback)(packagePolicy => {
    return packagePolicy.policy_ids.length || 0;
  }, []);
  const {
    data: outputsData,
    isLoading: isOutputsLoading
  } = (0, _hooks.useGetOutputs)();
  const {
    output: defaultOutputData
  } = (0, _hooks.useDefaultOutput)();
  const outputNamesById = (0, _react.useMemo)(() => {
    var _outputsData$items;
    const outputs = (_outputsData$items = outputsData === null || outputsData === void 0 ? void 0 : outputsData.items) !== null && _outputsData$items !== void 0 ? _outputsData$items : [];
    return outputs.reduce((acc, output) => {
      acc[output.id] = output.name;
      return acc;
    }, {});
  }, [outputsData]);
  const columns = (0, _react.useMemo)(() => [{
    field: 'name',
    sortable: true,
    truncateText: true,
    name: _i18n.i18n.translate('xpack.fleet.policyDetails.packagePoliciesTable.nameColumnTitle', {
      defaultMessage: 'Integration policy'
    }),
    width: '35%',
    render: (value, packagePolicy) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      "data-test-subj": "PackagePoliciesTableName",
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
      title: value
    }, canReadIntegrationPolicies ? {
      href: getHref('edit_integration', {
        policyId: agentPolicy.id,
        packagePolicyId: packagePolicy.id
      })
    } : {
      disabled: true
    }, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement("span", {
      className: "eui-textTruncate",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 17
      }
    }, value), packagePolicy.description ? /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 19
      }
    }, "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: packagePolicy.description,
      type: "question",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 21
      }
    })) : null)), enableOtelIntegrations && (0, _otelcol_helpers.packagePolicyHasOtelInputs)(packagePolicy === null || packagePolicy === void 0 ? void 0 : packagePolicy.inputs) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      type: "warning",
      color: "warning",
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.policyDetails.packagePoliciesTable.containsOtelPackages",
        defaultMessage: "The {integrationTitle} integration collects OpenTelemetry data adhering to semantic conventions and is available in technical preview. To collect OTel data, Elastic Agents must be on version {minVersion} or later.",
        values: {
          integrationTitle: packagePolicy.packageTitle,
          minVersion: _otelcol_helpers.OTEL_INPUTS_MINIMUM_VERSION
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 167,
          columnNumber: 21
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 17
      }
    })), canUseMultipleAgentPolicies && canReadAgentPolicies && canReadIntegrationPolicies && getSharedPoliciesNumber(packagePolicy) > 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyList.agentsColumn.sharedTooltip",
        defaultMessage: "This integration is shared by {numberShared} agent policies",
        values: {
          numberShared: getSharedPoliciesNumber(packagePolicy)
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 186,
          columnNumber: 23
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      "data-test-subj": "PackagePoliciesTableSharedLabel",
      color: "subdued",
      size: "xs",
      className: "eui-textNoWrap",
      tabIndex: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 193,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyList.agentsColumn.sharedText",
      defaultMessage: "Shared",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 200,
        columnNumber: 23
      }
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "info",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 204,
        columnNumber: 23
      }
    })))))
  }, {
    field: 'packageTitle',
    sortable: true,
    name: _i18n.i18n.translate('xpack.fleet.policyDetails.packagePoliciesTable.packageNameColumnTitle', {
      defaultMessage: 'Integration'
    }),
    render(packageTitle, packagePolicy) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "center",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 223,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        "data-test-subj": "PackagePoliciesTableLink",
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 224,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: packagePolicy.package && getHref('integration_details_overview', {
          pkgkey: (0, _services.pkgKeyFromPackageInfo)(packagePolicy.package)
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 225,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "center",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 233,
          columnNumber: 19
        }
      }, packagePolicy.package && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 235,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement(_components.PackageIcon, {
        packageName: packagePolicy.package.name,
        version: packagePolicy.package.version,
        size: "m",
        tryApi: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 236,
          columnNumber: 25
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 244,
          columnNumber: 21
        }
      }, packageTitle), packagePolicy.package && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 246,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued",
        size: "xs",
        className: "eui-textNoWrap",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 247,
          columnNumber: 25
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.policyDetails.packagePoliciesTable.packageVersion",
        defaultMessage: "v{version}",
        values: {
          version: packagePolicy.package.version
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 248,
          columnNumber: 27
        }
      })))))), packagePolicy.hasUpgrade && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 261,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        type: "warning",
        color: "warning",
        content: _i18n.i18n.translate('xpack.fleet.policyDetails.packagePoliciesTable.upgradeAvailable', {
          defaultMessage: 'Upgrade Available'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 262,
          columnNumber: 21
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 271,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "PackagePoliciesTableUpgradeButton",
        size: "s",
        minWidth: "0",
        isDisabled: !canWriteIntegrationPolicies,
        href: `${getHref('upgrade_package_policy', {
          policyId: agentPolicy.id,
          packagePolicyId: packagePolicy.id
        })}?from=fleet-policy-list`,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 272,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.policyDetails.packagePoliciesTable.upgradeButton",
        defaultMessage: "Upgrade",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 282,
          columnNumber: 23
        }
      })))));
    }
  }, {
    field: 'namespace',
    name: _i18n.i18n.translate('xpack.fleet.policyDetails.packagePoliciesTable.namespaceColumnTitle', {
      defaultMessage: 'Namespace'
    }),
    render: namespace => {
      return namespace ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 304,
          columnNumber: 13
        }
      }, namespace) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "default",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 307,
          columnNumber: 15
        }
      }, agentPolicy.namespace), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: "Namespace defined in parent agent policy",
        position: "right",
        type: "info",
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 308,
          columnNumber: 15
        }
      }));
    }
  }, {
    field: 'output_id',
    name: _i18n.i18n.translate('xpack.fleet.policyDetails.packagePoliciesTable.outputColumnTitle', {
      defaultMessage: 'Output'
    }),
    render: outputId => {
      if (isOutputsLoading) {
        return null;
      }
      if (outputId) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "hollow",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 328,
            columnNumber: 20
          }
        }, outputNamesById[outputId] || outputId);
      }
      if (agentPolicy.data_output_id) {
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "default",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 333,
            columnNumber: 17
          }
        }, outputNamesById[agentPolicy.data_output_id] || agentPolicy.data_output_id), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
          content: _i18n.i18n.translate('xpack.fleet.policyDetails.packagePoliciesTable.outputFromParentPolicyText', {
            defaultMessage: 'Output defined in parent agent policy'
          }),
          position: "right",
          type: "info",
          color: "subdued",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 337,
            columnNumber: 17
          }
        }));
      }
      if (defaultOutputData) {
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "default",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 354,
            columnNumber: 17
          }
        }, outputNamesById[defaultOutputData.id] || defaultOutputData.id), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
          content: _i18n.i18n.translate('xpack.fleet.policyDetails.packagePoliciesTable.outputFromFleetSettingsText', {
            defaultMessage: 'Output defined in Fleet settings'
          }),
          position: "right",
          type: "info",
          color: "subdued",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 358,
            columnNumber: 17
          }
        }));
      }
    }
  }, {
    name: _i18n.i18n.translate('xpack.fleet.policyDetails.packagePoliciesTable.actionsColumnTitle', {
      defaultMessage: 'Actions'
    }),
    width: '70px',
    actions: [{
      render: packagePolicy => {
        return canWriteIntegrationPolicies ? /*#__PURE__*/_react.default.createElement(_components.PackagePolicyActionsMenu, {
          agentPolicies: [agentPolicy],
          from: 'fleet-policy-list',
          packagePolicy: packagePolicy,
          upgradePackagePolicyHref: `${getHref('upgrade_package_policy', {
            policyId: agentPolicy.id,
            packagePolicyId: packagePolicy.id
          })}?from=fleet-policy-list`,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 383,
            columnNumber: 17
          }
        }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
      }
    }]
  }], [canReadIntegrationPolicies, getHref, agentPolicy, enableOtelIntegrations, canUseMultipleAgentPolicies, canReadAgentPolicies, getSharedPoliciesNumber, canWriteIntegrationPolicies, isOutputsLoading, defaultOutputData, outputNamesById]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, (0, _extends2.default)({
    itemId: "id",
    items: packagePolicies,
    columns: columns,
    sorting: {
      sort: {
        field: 'name',
        direction: 'asc'
      }
    }
  }, rest, {
    search: {
      toolsRight: agentPolicy.is_managed || agentPolicy.supports_agentless ? [] : [/*#__PURE__*/_react.default.createElement(_components.EuiButtonWithTooltip, {
        key: "addPackagePolicyButton",
        fill: true,
        isDisabled: !canWriteIntegrationPolicies,
        iconType: "plusInCircle",
        onClick: () => {
          setShowAddIntegrationFlyout(true);
        },
        "data-test-subj": "addPackagePolicyButton",
        tooltip: !canWriteIntegrationPolicies ? {
          content: missingSecurityConfiguration ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.fleet.epm.addPackagePolicyButtonSecurityRequiredTooltip",
            defaultMessage: "To add Elastic Agent Integrations, you must have security enabled and have the All privilege for Fleet. Contact your administrator.",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 446,
              columnNumber: 31
            }
          }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.fleet.epm.addPackagePolicyButtonPrivilegesRequiredTooltip",
            defaultMessage: "Elastic Agent Integrations require the All privilege for Agent policies and All privilege for Integrations. Contact your administrator.",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 451,
              columnNumber: 31
            }
          })
        } : undefined,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 433,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.policyDetails.addPackagePolicyButtonText",
        defaultMessage: "Add integration",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 460,
          columnNumber: 21
        }
      }))],
      box: {
        incremental: true,
        schema: true
      },
      filters: [{
        type: 'field_value_selection',
        field: 'namespace',
        name: 'Namespace',
        options: namespaces,
        multiSelect: 'or',
        operator: 'exact'
      }]
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 417,
      columnNumber: 7
    }
  })), showAddIntegrationFlyout && /*#__PURE__*/_react.default.createElement(_add_integration_flyout.AddIntegrationFlyout, {
    onClose: () => {
      setShowAddIntegrationFlyout(false);
      refreshAgentPolicy();
    },
    agentPolicy: agentPolicy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 483,
      columnNumber: 9
    }
  }));
};
exports.PackagePoliciesTable = PackagePoliciesTable;