"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackagePolicyInputConfig = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _services = require("../../../services");
var _package_policy_input_var_field = require("./package_policy_input_var_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/create_package_policy_page/components/steps/components/package_policy_input_config.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PackagePolicyInputConfig = exports.PackagePolicyInputConfig = /*#__PURE__*/(0, _react.memo)(({
  hasInputStreams,
  packageInputVars,
  packagePolicyInput,
  updatePackagePolicyInput,
  inputValidationResults,
  forceShowErrors,
  isEditPage = false
}) => {
  // Showing advanced options toggle state
  const [isShowingAdvanced, setIsShowingAdvanced] = (0, _react.useState)(false);

  // Split vars into required and advanced
  const [requiredVars, advancedVars] = (0, _react.useMemo)(() => {
    const _advancedVars = [];
    const _requiredVars = [];
    (packageInputVars || []).forEach(varDef => {
      if ((0, _services.isAdvancedVar)(varDef)) {
        _advancedVars.push(varDef);
      } else {
        _requiredVars.push(varDef);
      }
    });
    return [_requiredVars, _advancedVars];
  }, [packageInputVars]);

  // Errors state
  const hasErrors = forceShowErrors && (0, _services.validationHasErrors)(inputValidationResults);
  const hasRequiredVarGroupErrors = inputValidationResults.required_vars;
  const advancedVarsWithErrorsCount = (0, _react.useMemo)(() => advancedVars.filter(({
    name: varName
  }) => {
    var _inputValidationResul, _inputValidationResul2;
    return (_inputValidationResul = inputValidationResults.vars) === null || _inputValidationResul === void 0 ? void 0 : (_inputValidationResul2 = _inputValidationResul[varName]) === null || _inputValidationResul2 === void 0 ? void 0 : _inputValidationResul2.length;
  }).length, [advancedVars, inputValidationResults.vars]);
  const isBiggerScreen = (0, _eui.useIsWithinMinBreakpoint)('xxl');
  const flexWidth = isBiggerScreen ? 7 : 5;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: flexWidth,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicy.stepConfigure.inputSettingsTitle",
    defaultMessage: "Settings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 19
    }
  }))), hasInputStreams ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicy.stepConfigure.inputSettingsDescription",
    defaultMessage: "The following settings are applicable to all inputs below.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 23
    }
  })))) : null, hasRequiredVarGroupErrors && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: `${packagePolicyInput.type}-required-vars-group-error`,
    paddingSize: "s",
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "danger",
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.stepConfigure.requiredVarsGroupErrorText",
      defaultMessage: "One of these settings groups is required",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 25
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 21
    }
  }, Object.entries(inputValidationResults.required_vars || {}).map(([groupName, vars]) => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 31
      }
    }, groupName), /*#__PURE__*/_react.default.createElement("ul", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 31
      }
    }, vars.map(({
      name
    }) => /*#__PURE__*/_react.default.createElement("li", {
      key: `${groupName}-${name}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 35
      }
    }, name))));
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 11
    }
  }, requiredVars.map(varDef => {
    var _packagePolicyInput$v, _packagePolicyInput$v2, _packagePolicyInput$v3, _packagePolicyInput$v4, _inputValidationResul3;
    const {
      name: varName,
      type: varType
    } = varDef;
    const value = (_packagePolicyInput$v = packagePolicyInput.vars) === null || _packagePolicyInput$v === void 0 ? void 0 : (_packagePolicyInput$v2 = _packagePolicyInput$v[varName]) === null || _packagePolicyInput$v2 === void 0 ? void 0 : _packagePolicyInput$v2.value;
    const frozen = (_packagePolicyInput$v3 = packagePolicyInput.vars) === null || _packagePolicyInput$v3 === void 0 ? void 0 : (_packagePolicyInput$v4 = _packagePolicyInput$v3[varName]) === null || _packagePolicyInput$v4 === void 0 ? void 0 : _packagePolicyInput$v4.frozen;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: varName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_package_policy_input_var_field.PackagePolicyInputVarField, {
      varDef: varDef,
      value: value,
      frozen: frozen,
      onChange: newValue => {
        updatePackagePolicyInput({
          vars: {
            ...packagePolicyInput.vars,
            [varName]: {
              type: varType,
              value: newValue
            }
          }
        });
      },
      errors: (_inputValidationResul3 = inputValidationResults.vars) === null || _inputValidationResul3 === void 0 ? void 0 : _inputValidationResul3[varName],
      forceShowErrors: forceShowErrors,
      isEditPage: isEditPage,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 19
      }
    }));
  }), advancedVars.length ? /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    iconType: isShowingAdvanced ? 'arrowDown' : 'arrowRight',
    onClick: () => setIsShowingAdvanced(!isShowingAdvanced),
    flush: "left",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicy.stepConfigure.toggleAdvancedOptionsButtonText",
    defaultMessage: "Advanced options",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 25
    }
  }))), !isShowingAdvanced && hasErrors && advancedVarsWithErrorsCount ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "danger",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicy.stepConfigure.errorCountText",
    defaultMessage: "{count, plural, one {# error} other {# errors}}",
    values: {
      count: advancedVarsWithErrorsCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 27
    }
  }))) : null)), isShowingAdvanced ? advancedVars.map(varDef => {
    var _packagePolicyInput$v5, _packagePolicyInput$v6, _inputValidationResul4;
    const {
      name: varName,
      type: varType
    } = varDef;
    const value = (_packagePolicyInput$v5 = packagePolicyInput.vars) === null || _packagePolicyInput$v5 === void 0 ? void 0 : (_packagePolicyInput$v6 = _packagePolicyInput$v5[varName]) === null || _packagePolicyInput$v6 === void 0 ? void 0 : _packagePolicyInput$v6.value;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: varName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 207,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_package_policy_input_var_field.PackagePolicyInputVarField, {
      varDef: varDef,
      value: value,
      onChange: newValue => {
        updatePackagePolicyInput({
          vars: {
            ...packagePolicyInput.vars,
            [varName]: {
              type: varType,
              value: newValue
            }
          }
        });
      },
      errors: (_inputValidationResul4 = inputValidationResults.vars) === null || _inputValidationResul4 === void 0 ? void 0 : _inputValidationResul4[varName],
      forceShowErrors: forceShowErrors,
      isEditPage: isEditPage,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 208,
        columnNumber: 27
      }
    }));
  }) : null) : null)));
});