"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAddFleetServerHostStep = exports.AddFleetServerHostStepContent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../hooks");
var _multi_row_input = require("../../../sections/settings/components/multi_row_input");
var _components = require("../components");
var _ssl_form_section = require("../../../sections/settings/components/fleet_server_hosts_flyout/ssl_form_section");
var _services = require("../../../services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/components/fleet_server_instructions/steps/add_fleet_server_host.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getAddFleetServerHostStep = ({
  fleetServerHostForm,
  disabled,
  onClose
}) => {
  return {
    title: _i18n.i18n.translate('xpack.fleet.fleetServerSetup.addFleetServerHostStepTitle', {
      defaultMessage: 'Add your Fleet Server host'
    }),
    status: disabled ? 'disabled' : undefined,
    children: disabled ? null : /*#__PURE__*/_react.default.createElement(AddFleetServerHostStepContent, {
      fleetServerHostForm: fleetServerHostForm,
      onClose: onClose,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 7
      }
    })
  };
};
exports.getAddFleetServerHostStep = getAddFleetServerHostStep;
const AddFleetServerHostStepContent = ({
  fleetServerHostForm,
  onClose
}) => {
  const {
    setFleetServerHost,
    fleetServerHost: selectedFleetServerHost,
    handleSubmitForm,
    fleetServerHosts,
    error,
    inputs
  } = fleetServerHostForm;
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [submittedFleetServerHost, setSubmittedFleetServerHost] = (0, _react.useState)();
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const {
    getHref
  } = (0, _hooks.useLink)();
  const {
    enableSSLSecrets
  } = _services.ExperimentalFeaturesService.get();
  const [isFirstLoad, setIsFirstLoad] = _react.default.useState(true);
  const [isConvertedToSecret, setIsConvertedToSecret] = _react.default.useState({
    sslKey: false,
    sslESKey: false
  });
  const [secretsToggleState, setSecretsToggleState] = (0, _react.useState)(true);
  const useSecretsStorage = secretsToggleState === true;
  const fleetStatus = (0, _hooks.useFleetStatus)();
  if (fleetStatus.isSecretsStorageEnabled !== undefined && secretsToggleState === 'disabled') {
    setSecretsToggleState(fleetStatus.isSecretsStorageEnabled);
  }
  const onToggleSecretStorage = secretEnabled => {
    if (secretsToggleState === 'disabled') {
      return;
    }
    setSecretsToggleState(secretEnabled);
  };
  (0, _react.useEffect)(() => {
    if (!isFirstLoad) return;
    setIsFirstLoad(false);
    // populate the secret input with the value of the plain input in order to re-save the key with secret storage
    if (useSecretsStorage && enableSSLSecrets) {
      if (inputs.sslKeyInput.value && !inputs.sslKeySecretInput.value) {
        inputs.sslKeySecretInput.setValue(inputs.sslKeyInput.value);
        inputs.sslKeyInput.clear();
        setIsConvertedToSecret({
          ...isConvertedToSecret,
          sslKey: true
        });
      }
      if (inputs.sslESKeyInput.value && !inputs.sslESKeySecretInput.value) {
        inputs.sslESKeySecretInput.setValue(inputs.sslESKeyInput.value);
        inputs.sslESKeyInput.clear();
        setIsConvertedToSecret({
          ...isConvertedToSecret,
          sslESKey: true
        });
      }
    }
  }, [inputs.sslKeyInput, inputs.sslKeySecretInput, isFirstLoad, setIsFirstLoad, isConvertedToSecret, inputs.sslESKeyInput, inputs.sslESKeySecretInput, secretsToggleState, useSecretsStorage, enableSSLSecrets]);
  const onToggleSecretAndClearValue = secretEnabled => {
    if (secretEnabled) {
      inputs.sslKeyInput.clear();
      inputs.sslESKeyInput.clear();
    } else {
      inputs.sslKeySecretInput.setValue('');
      inputs.sslESKeySecretInput.setValue('');
    }
    setIsConvertedToSecret({
      ...isConvertedToSecret,
      sslKey: false,
      sslESKey: false
    });
    onToggleSecretStorage(secretEnabled);
  };
  const onSubmit = (0, _react.useCallback)(async () => {
    try {
      setSubmittedFleetServerHost(undefined);
      setIsLoading(true);
      const savedFleetServerHost = await handleSubmitForm();
      if (savedFleetServerHost) {
        setFleetServerHost(savedFleetServerHost);
        setSubmittedFleetServerHost(savedFleetServerHost);
      }
    } catch (err) {
      notifications.toasts.addError(err, {
        title: _i18n.i18n.translate('xpack.fleet.fleetServerSetup.errorAddingFleetServerHostTitle', {
          defaultMessage: 'Error adding Fleet Server host'
        })
      });
    } finally {
      setIsLoading(false);
    }
  }, [handleSubmitForm, setFleetServerHost, notifications.toasts]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    onSubmit: onSubmit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.fleetServerSetup.addFleetServerHostStepDescription",
    defaultMessage: "First, set the public IP or host name and port that agents will use to reach Fleet Server. It uses port {port} by default {toolTip}. We'll then generate a policy for you automatically. ",
    values: {
      port: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 167,
          columnNumber: 19
        }
      }, "8220"),
      toolTip: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        iconProps: {
          className: 'eui-alignTop'
        },
        content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.fleetServerSetup.getStartedInstructionsPortTooltips",
          defaultMessage: "This can only be set during Fleet Server installation.",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 174,
            columnNumber: 19
          }
        }),
        position: "right",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 169,
          columnNumber: 15
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 7
    }
  }), selectedFleetServerHost ? /*#__PURE__*/_react.default.createElement(_components.FleetServerHostSelect, {
    setFleetServerHost: setFleetServerHost,
    selectedFleetServerHost: selectedFleetServerHost,
    fleetServerHosts: fleetServerHosts,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 9
    }
  }) : null, !selectedFleetServerHost ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.fleetServerSetup.nameInputLabel",
      defaultMessage: "Name",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 198,
        columnNumber: 15
      }
    })
  }, inputs.nameInput.formRowProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
    "data-test-subj": "fleetServerSetup.nameInput",
    fullWidth: true,
    placeholder: _i18n.i18n.translate('xpack.fleet.fleetServerSetup.nameInputPlaceholder', {
      defaultMessage: 'Specify name'
    })
  }, inputs.nameInput.props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.fleetServerSetup.hostUrlLabel",
      defaultMessage: "URL",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 217,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_multi_row_input.MultiRowInput, (0, _extends2.default)({
    "data-test-subj": "fleetServerSetup.multiRowInput"
  }, inputs.hostUrlsInput.props, {
    placeholder: _i18n.i18n.translate('xpack.fleet.fleetServerSetup.fleetServerHostsInputPlaceholder', {
      defaultMessage: 'Specify host URL'
    }),
    isUrl: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 15
    }
  })), error && /*#__PURE__*/_react.default.createElement(_eui.EuiFormErrorText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 25
    }
  }, error))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_ssl_form_section.SSLFormSection, {
    inputs: inputs,
    useSecretsStorage: enableSSLSecrets && useSecretsStorage,
    onToggleSecretAndClearValue: onToggleSecretAndClearValue,
    isConvertedToSecret: isConvertedToSecret,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 11
    }
  }), fleetServerHosts.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true
  }, inputs.isDefaultInput.formRowProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, (0, _extends2.default)({
    "data-test-subj": "fleetServerHostsFlyout.isDefaultSwitch"
  }, inputs.isDefaultInput.props, {
    disabled: false,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.fleetServerHostsFlyout.defaultOutputSwitchLabel",
      defaultMessage: "Make this Fleet server the default one.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 253,
        columnNumber: 19
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 15
    }
  }))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isLoading: isLoading,
    onClick: onSubmit,
    "data-test-subj": "fleetServerAddHostBtn",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.fleetServerSetup.addFleetServerHostButton",
    defaultMessage: "Add host",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 13
    }
  }))) : null, submittedFleetServerHost && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "check",
    color: "success",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.fleetServerSetup.addFleetServerHostSuccessTitle",
      defaultMessage: "Added Fleet Server host",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 280,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.fleetServerSetup.addFleetServerHostSuccessText",
    defaultMessage: "Added {host}. You can edit your Fleet Server hosts in {fleetSettingsLink}.",
    values: {
      host: submittedFleetServerHost.host_urls[0],
      fleetSettingsLink:
      /*#__PURE__*/
      // eslint-disable-next-line @elastic/eui/href-or-on-click
      _react.default.createElement(_eui.EuiLink, {
        href: getHref('settings'),
        onClick: onClose,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 293,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.fleetServerSetup.fleetSettingsLink",
        defaultMessage: "Fleet Settings",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 294,
          columnNumber: 21
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 286,
      columnNumber: 13
    }
  }))));
};
exports.AddFleetServerHostStepContent = AddFleetServerHostStepContent;