"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReferenceLineAnnotations = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _charts = require("@elastic/charts");
var _uiTheme = require("@kbn/ui-theme");
var _react = _interopRequireDefault(require("react"));
var _helpers = require("../../helpers");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/chart_expressions/expression_xy/public/components/reference_lines/reference_line_annotations.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const getRectDataValue = (annotationConfig, formatter, groupId) => {
  const {
    name,
    value,
    nextValue,
    fill
  } = annotationConfig;
  const isFillAbove = fill === 'above';
  if (groupId === _charts.Position.Bottom) {
    return (0, _utils.getBottomRect)(name, isFillAbove, formatter, value, nextValue);
  }
  return (0, _utils.getHorizontalRect)(name, isFillAbove, formatter, value, nextValue);
};
const ReferenceLineAnnotations = ({
  config,
  axesMap,
  formatter,
  paddingMap,
  isHorizontal
}) => {
  var _axisGroup$position;
  const {
    id,
    axisGroup,
    iconPosition,
    name,
    value,
    fill,
    color
  } = config;
  const defaultColor = _uiTheme.euiLightVars.euiColorDarkShade;
  // get the position for vertical chart
  const markerPositionVertical = (0, _utils.getBaseIconPlacement)(iconPosition, axesMap, (0, _helpers.getOriginalAxisPosition)((_axisGroup$position = axisGroup === null || axisGroup === void 0 ? void 0 : axisGroup.position) !== null && _axisGroup$position !== void 0 ? _axisGroup$position : _charts.Position.Bottom, isHorizontal));
  // the padding map is built for vertical chart
  const isTextOnlyMarker = paddingMap[markerPositionVertical] === _helpers.LINES_MARKER_SIZE;
  const props = (0, _utils.getLineAnnotationProps)(config, name, axesMap, isHorizontal, isTextOnlyMarker);
  const sharedStyle = (0, _utils.getSharedStyle)(config);
  const dataValues = {
    dataValue: value,
    header: name,
    details: (formatter === null || formatter === void 0 ? void 0 : formatter.convert(value)) || (value === null || value === void 0 ? void 0 : value.toString())
  };
  const line = /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, (0, _extends2.default)({}, props, {
    id: `${id}-line`,
    key: `${id}-line`,
    dataValues: [dataValues],
    domainType: props.groupId === _charts.Position.Bottom ? _charts.AnnotationDomainType.XDomain : _charts.AnnotationDomainType.YDomain,
    style: {
      line: {
        ...sharedStyle,
        opacity: 1
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 5
    }
  }));
  let rect;
  if (fill && fill !== 'none') {
    const rectDataValues = getRectDataValue(config, formatter, props.groupId);
    rect = /*#__PURE__*/_react.default.createElement(_charts.RectAnnotation, (0, _extends2.default)({}, props, {
      id: `${id}-rect`,
      key: `${id}-rect`,
      dataValues: [rectDataValues],
      style: {
        ...sharedStyle,
        fill: color || defaultColor,
        opacity: 0.1
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 7
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, line, rect);
};
exports.ReferenceLineAnnotations = ReferenceLineAnnotations;