"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LegendColorPickerWrapperContext = exports.LegendColorPickerWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _chromaJs = _interopRequireDefault(require("chroma-js"));
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _public = require("@kbn/charts-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/chart_expressions/expression_partition_vis/public/utils/get_color_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const KEY_CODE_ENTER = 13;
function getAnchorPosition(legendPosition) {
  switch (legendPosition) {
    case _charts.Position.Bottom:
      return 'upCenter';
    case _charts.Position.Top:
      return 'downCenter';
    case _charts.Position.Left:
      return 'rightCenter';
    default:
      return 'leftCenter';
  }
}
function getLayerIndex(seriesKey, data, layers) {
  const row = data.find(d => Object.keys(d).find(key => d[key] === seriesKey));
  const bucketId = row && Object.keys(row).find(key => row[key] === seriesKey);
  return layers.findIndex(layer => layer.id === bucketId) + 1;
}
function isOnInnerLayer(firstBucket, data, seriesKey) {
  return data.find(d => firstBucket.id && d[firstBucket.id] === seriesKey);
}
const LegendColorPickerWrapperContext = exports.LegendColorPickerWrapperContext = /*#__PURE__*/(0, _react.createContext)(undefined);
const LegendColorPickerWrapper = ({
  anchor,
  color,
  onClose,
  onChange,
  seriesIdentifiers: [seriesIdentifier]
}) => {
  var _uiState$get;
  const seriesName = seriesIdentifier.key;
  const colorPickerWrappingContext = (0, _react.useContext)(LegendColorPickerWrapperContext);
  const handleOutsideClick = (0, _react.useCallback)(() => {
    onClose === null || onClose === void 0 ? void 0 : onClose();
  }, [onClose]);
  if (!colorPickerWrappingContext) {
    return null;
  }
  const {
    legendPosition,
    setColor,
    bucketColumns,
    palette,
    data,
    uiState,
    distinctColors
  } = colorPickerWrappingContext;
  const overwriteColors = (_uiState$get = uiState === null || uiState === void 0 ? void 0 : uiState.get('vis.colors', {})) !== null && _uiState$get !== void 0 ? _uiState$get : {};
  const colorIsOverwritten = Object.keys(overwriteColors).includes(seriesName.toString());
  let keyDownEventOn = false;
  const handleChange = newColor => {
    if (newColor) {
      onChange(newColor);
    }
    setColor(newColor, seriesName);
    // close the popover if no color is applied or the user has clicked a color
    if (!newColor || !keyDownEventOn) {
      onClose();
    }
  };
  const onKeyDown = e => {
    if (e.keyCode === KEY_CODE_ENTER) {
      onClose === null || onClose === void 0 ? void 0 : onClose();
    }
    keyDownEventOn = true;
  };
  if (!distinctColors) {
    const enablePicker = isOnInnerLayer(bucketColumns[0], data, seriesName) || !bucketColumns[0].id;
    if (!enablePicker) return null;
  }
  const hexColor = (0, _chromaJs.default)(color).hex();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiOutsideClickDetector, {
    onOutsideClick: handleOutsideClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiWrappingPopover, {
    isOpen: true,
    ownFocus: true,
    display: "block",
    button: anchor,
    anchorPosition: getAnchorPosition(legendPosition),
    closePopover: onClose,
    panelPaddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_public.ColorPicker, {
    color: palette === 'kibana_palette' ? hexColor : hexColor.toLowerCase(),
    onChange: handleChange,
    label: seriesName,
    maxDepth: bucketColumns.length,
    layerIndex: getLayerIndex(seriesName, data, bucketColumns),
    useLegacyColors: palette === 'kibana_palette',
    colorIsOverwritten: colorIsOverwritten,
    onKeyDown: onKeyDown,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 9
    }
  })));
};
exports.LegendColorPickerWrapper = LegendColorPickerWrapper;