"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LicensingCallout = exports.LICENSING_FEATURE = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _doc_links = require("../doc_links/doc_links");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/shared/licensing_callout/licensing_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let LICENSING_FEATURE = exports.LICENSING_FEATURE = /*#__PURE__*/function (LICENSING_FEATURE) {
  LICENSING_FEATURE["NATIVE_CONNECTOR"] = "nativeConnector";
  LICENSING_FEATURE["CRAWLER"] = "crawler";
  LICENSING_FEATURE["INFERENCE"] = "inference";
  LICENSING_FEATURE["PIPELINES"] = "pipelines";
  LICENSING_FEATURE["SEARCH_APPLICATIONS"] = "searchApplications";
  LICENSING_FEATURE["ANALYTICS"] = "analytics";
  return LICENSING_FEATURE;
}({});
const LicensingCallout = ({
  feature
}) => {
  const firstContentBlock = {
    [LICENSING_FEATURE.NATIVE_CONNECTOR]: _i18n.i18n.translate('xpack.enterpriseSearch.content.licensingCallout.nativeConnector.contentOne', {
      defaultMessage: 'Built-in connectors require a Platinum license or higher and are not available to Standard license self-managed deployments. You need to upgrade to use this feature.'
    }),
    [LICENSING_FEATURE.CRAWLER]: _i18n.i18n.translate('xpack.enterpriseSearch.content.licensingCallout.crawler.contentOne', {
      defaultMessage: 'The web crawler requires a Platinum license or higher and is not available to Standard license self-managed deployments. You need to upgrade to use this feature.'
    }),
    [LICENSING_FEATURE.INFERENCE]: _i18n.i18n.translate('xpack.enterpriseSearch.content.licensingCallout.inference.contentOne', {
      defaultMessage: 'Inference processors require a Platinum license or higher and are not available to Standard license self-managed deployments. You need to upgrade to use this feature.'
    }),
    [LICENSING_FEATURE.PIPELINES]: _i18n.i18n.translate('xpack.enterpriseSearch.content.licensingCallout.pipelines.contentOne', {
      defaultMessage: 'Custom pipelines require a Platinum license or higher and are not available to Standard license self-managed deployments. You need to upgrade to use this feature.'
    }),
    [LICENSING_FEATURE.SEARCH_APPLICATIONS]: _i18n.i18n.translate('xpack.enterpriseSearch.content.licensingCallout.searchApplications.contentOne', {
      defaultMessage: 'Search applications require a Platinum license or higher and are not available to Standard license self-managed deployments. You need to upgrade to use this feature.'
    }),
    [LICENSING_FEATURE.ANALYTICS]: _i18n.i18n.translate('xpack.enterpriseSearch.content.licensingCallout.analytics.contentOne', {
      defaultMessage: 'Behavioral Analytics require a Platinum license or higher and are not available to Standard license self-managed deployments. You need to upgrade to use this feature.'
    })
  };
  const secondContentBlock = {
    [LICENSING_FEATURE.NATIVE_CONNECTOR]: _i18n.i18n.translate('xpack.enterpriseSearch.content.licensingCallout.contentTwo', {
      defaultMessage: "Did you know that built-in connectors are available with a Standard Elastic Cloud license? Elastic Cloud gives you the flexibility to run where you want. Deploy our managed service on Google Cloud, Microsoft Azure, or Amazon Web Services, and we'll handle the maintenance and upkeep for you."
    }),
    [LICENSING_FEATURE.CRAWLER]: _i18n.i18n.translate('xpack.enterpriseSearch.content.licensingCallout.crawler.contentTwo', {
      defaultMessage: "Did you know that web crawlers are available with a Standard Elastic Cloud license? Elastic Cloud gives you the flexibility to run where you want. Deploy our managed service on Google Cloud, Microsoft Azure, or Amazon Web Services, and we'll handle the maintenance and upkeep for you."
    }),
    [LICENSING_FEATURE.INFERENCE]: _i18n.i18n.translate('xpack.enterpriseSearch.content.licensingCallout.inference.contentTwo', {
      defaultMessage: "Did you know that inference processors are available with a Standard Elastic Cloud license? Elastic Cloud gives you the flexibility to run where you want. Deploy our managed service on Google Cloud, Microsoft Azure, or Amazon Web Services, and we'll handle the maintenance and upkeep for you."
    }),
    [LICENSING_FEATURE.PIPELINES]: _i18n.i18n.translate('xpack.enterpriseSearch.content.licensingCallout.pipelines.contentTwo', {
      defaultMessage: "Did you know that custom pipelines are available with a Standard Elastic Cloud license? Elastic Cloud gives you the flexibility to run where you want. Deploy our managed service on Google Cloud, Microsoft Azure, or Amazon Web Services, and we'll handle the maintenance and upkeep for you."
    }),
    [LICENSING_FEATURE.SEARCH_APPLICATIONS]: _i18n.i18n.translate('xpack.enterpriseSearch.content.licensingCallout.searchApplications.contentTwo', {
      defaultMessage: "Did you know that search applications are available with a Standard Elastic Cloud license? Elastic Cloud gives you the flexibility to run where you want. Deploy our managed service on Google Cloud, Microsoft Azure, or Amazon Web Services and we'll handle the maintenance and upkeep for you."
    }),
    [LICENSING_FEATURE.ANALYTICS]: _i18n.i18n.translate('xpack.enterpriseSearch.content.licensingCallout.analytics.contentTwo', {
      defaultMessage: "Did you know that Behavioral Analytics are available with a Standard Elastic Cloud license? Elastic Cloud gives you the flexibility to run where you want. Deploy our managed service on Google Cloud, Microsoft Azure, or Amazon Web Services and we'll handle the maintenance and upkeep for you."
    })
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.licensingCallout.title', {
      defaultMessage: 'Platinum features'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 7
    }
  }, firstContentBlock[feature]), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 7
    }
  }, secondContentBlock[feature]), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    external: true,
    href: _doc_links.docLinks.licenseManagement,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.explorePlatinumFeatures.link', {
    defaultMessage: 'Explore Platinum features'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: "https://www.elastic.co/subscriptions/cloud",
    external: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.licensingCallout.contentCloudTrial', {
    defaultMessage: 'Explore Enterprise Search on Elastic Cloud '
  })))));
};
exports.LicensingCallout = LicensingCallout;