"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEnterpriseSearchNav = exports.useEnterpriseSearchApplicationNav = exports.useEnterpriseSearchAnalyticsNav = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../common/constants");
var _routes = require("../../applications/routes");
var _kibana = require("../kibana");
var _classic_nav_helpers = require("./classic_nav_helpers");
var _nav_link_helpers = require("./nav_link_helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/shared/layout/nav.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Hook to generate the Enterprise Search navigation items
 *
 * @param alwaysReturn Flag to always return the nav items, even if the sidebar is disabled
 * @returns The Enterprise Search navigation items
 */
const useEnterpriseSearchNav = (alwaysReturn = false) => {
  const {
    isSidebarEnabled,
    getNavLinks,
    searchNavigation
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const navItems = (0, _react.useMemo)(() => {
    const baseNavItems = searchNavigation.getBaseClassicNavItems();
    const deepLinks = getNavLinks().reduce((links, link) => {
      links[link.id] = link;
      return links;
    }, {});
    return (0, _classic_nav_helpers.generateSideNavItems)(baseNavItems, deepLinks);
  }, []);
  if (!isSidebarEnabled && !alwaysReturn) return undefined;
  return navItems;
};
exports.useEnterpriseSearchNav = useEnterpriseSearchNav;
const useEnterpriseSearchApplicationNav = (searchApplicationName, isEmptyState, hasSchemaConflicts, alwaysReturn) => {
  var _applicationsItem$ite;
  const navItems = useEnterpriseSearchNav(alwaysReturn);
  if (!navItems) return undefined;
  if (!searchApplicationName) return navItems;
  const applicationsItem = navItems.find(item => item.id === 'build');
  if (!applicationsItem || !applicationsItem.items) return navItems;
  const searchApplicationsItem = (_applicationsItem$ite = applicationsItem.items) === null || _applicationsItem$ite === void 0 ? void 0 : _applicationsItem$ite.find(item => item.id === 'searchApplications');
  if (!searchApplicationsItem || searchApplicationsItem.id !== 'searchApplications') return navItems;
  const searchApplicationPath = `${_constants.APPLICATIONS_PLUGIN.URL}${_routes.SEARCH_APPLICATIONS_PATH}/${searchApplicationName}`;
  searchApplicationsItem.items = !isEmptyState ? [{
    id: 'searchApplicationId',
    name: searchApplicationName,
    ...(0, _nav_link_helpers.generateNavLink)({
      shouldNotCreateHref: true,
      shouldShowActiveForSubroutes: false,
      to: searchApplicationPath
    }),
    items: [{
      id: 'enterpriseSearchApplicationDocsExplorer',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.searchApplication.docsExplorerTitle', {
        defaultMessage: 'Docs Explorer'
      }),
      ...(0, _nav_link_helpers.generateNavLink)({
        shouldNotCreateHref: true,
        to: `${searchApplicationPath}/${_routes.SearchApplicationViewTabs.DOCS_EXPLORER}`
      })
    }, {
      // Required for the new side nav
      iconToString: hasSchemaConflicts ? 'warning' : undefined,
      id: 'enterpriseSearchApplicationsContent',
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "spaceBetween",
        alignItems: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 96,
          columnNumber: 17
        }
      }, _i18n.i18n.translate('xpack.enterpriseSearch.nav.searchApplication.contentTitle', {
        defaultMessage: 'Content'
      }), hasSchemaConflicts && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "warning",
        color: "danger",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 100,
          columnNumber: 42
        }
      })),
      // Required for the new side nav
      nameToString: _i18n.i18n.translate('xpack.enterpriseSearch.nav.searchApplication.contentTitle', {
        defaultMessage: 'Content'
      }),
      ...(0, _nav_link_helpers.generateNavLink)({
        shouldNotCreateHref: true,
        shouldShowActiveForSubroutes: true,
        to: `${searchApplicationPath}/${_routes.SearchApplicationViewTabs.CONTENT}`
      })
    }, {
      id: 'enterpriseSearchApplicationConnect',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.applications.searchApplications.connectTitle', {
        defaultMessage: 'Connect'
      }),
      ...(0, _nav_link_helpers.generateNavLink)({
        shouldNotCreateHref: true,
        shouldShowActiveForSubroutes: true,
        to: `${searchApplicationPath}/${_routes.SearchApplicationViewTabs.CONNECT}`
      })
    }]
  }] : [{
    id: 'searchApplicationId',
    name: searchApplicationName,
    ...(0, _nav_link_helpers.generateNavLink)({
      shouldNotCreateHref: true,
      shouldShowActiveForSubroutes: true,
      to: searchApplicationPath
    })
  }];
  return navItems;
};
exports.useEnterpriseSearchApplicationNav = useEnterpriseSearchApplicationNav;
const useEnterpriseSearchAnalyticsNav = (name, paths, alwaysReturn) => {
  var _applicationsNav$item;
  const navItems = useEnterpriseSearchNav(alwaysReturn);
  if (!navItems) return undefined;
  const applicationsNav = navItems.find(item => item.id === 'build');
  const analyticsNav = applicationsNav === null || applicationsNav === void 0 ? void 0 : (_applicationsNav$item = applicationsNav.items) === null || _applicationsNav$item === void 0 ? void 0 : _applicationsNav$item.find(item => item.id === 'analyticsCollections');
  if (!name && !analyticsNav) {
    var _applicationsNav$item2;
    applicationsNav === null || applicationsNav === void 0 ? void 0 : (_applicationsNav$item2 = applicationsNav.items) === null || _applicationsNav$item2 === void 0 ? void 0 : _applicationsNav$item2.push({
      id: 'analyticsCollections',
      name: _constants.ANALYTICS_PLUGIN.NAME,
      ...(0, _nav_link_helpers.generateNavLink)({
        shouldNotCreateHref: true,
        shouldShowActiveForSubroutes: false,
        to: _constants.ANALYTICS_PLUGIN.URL
      })
    });
    return navItems;
  }
  if (!paths || analyticsNav) return navItems;
  if (!analyticsNav) {
    var _applicationsNav$item3;
    applicationsNav === null || applicationsNav === void 0 ? void 0 : (_applicationsNav$item3 = applicationsNav.items) === null || _applicationsNav$item3 === void 0 ? void 0 : _applicationsNav$item3.push({
      id: 'analyticsCollections',
      name: _constants.ANALYTICS_PLUGIN.NAME,
      ...(0, _nav_link_helpers.generateNavLink)({
        shouldNotCreateHref: true,
        shouldShowActiveForSubroutes: false,
        to: _constants.ANALYTICS_PLUGIN.URL
      }),
      items: [...(paths ? [{
        id: 'analyticsCollection',
        items: [{
          id: 'analyticsCollectionOverview',
          name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.analyticsCollections.overviewTitle', {
            defaultMessage: 'Overview'
          }),
          ...(0, _nav_link_helpers.generateNavLink)({
            shouldNotCreateHref: true,
            to: _constants.ANALYTICS_PLUGIN.URL + paths.overview
          })
        }, {
          id: 'analyticsCollectionExplorer',
          name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.analyticsCollections.explorerTitle', {
            defaultMessage: 'Explorer'
          }),
          ...(0, _nav_link_helpers.generateNavLink)({
            shouldNotCreateHref: true,
            to: _constants.ANALYTICS_PLUGIN.URL + paths.explorer
          })
        }, {
          id: 'analyticsCollectionIntegration',
          name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.analyticsCollections.integrationTitle', {
            defaultMessage: 'Integration'
          }),
          ...(0, _nav_link_helpers.generateNavLink)({
            shouldNotCreateHref: true,
            to: _constants.ANALYTICS_PLUGIN.URL + paths.integration
          })
        }],
        name
      }] : [])]
    });
  }
  return navItems;
};
exports.useEnterpriseSearchAnalyticsNav = useEnterpriseSearchAnalyticsNav;