"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InferenceErrors = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _data_panel = require("../../../../shared/data_panel/data_panel");
var _fetch_ml_inference_pipeline_errors = require("../../../api/pipelines/fetch_ml_inference_pipeline_errors");
var _inference_errors_logic = require("./inference_errors_logic");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/enterprise_search_content/components/search_index/pipelines/inference_errors.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const InferenceErrors = () => {
  const {
    indexName,
    isLoading,
    inferenceErrors
  } = (0, _kea.useValues)(_inference_errors_logic.InferenceErrorsLogic);
  const {
    makeRequest
  } = (0, _kea.useActions)(_fetch_ml_inference_pipeline_errors.FetchMlInferenceErrorsApiLogic);
  (0, _react.useEffect)(() => {
    makeRequest({
      indexName
    });
  }, [indexName]);
  const errorsColumns = [{
    dataType: 'date',
    field: 'timestamp',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.pipelineInferenceLogs.tableColumn.timestamp', {
      defaultMessage: 'Timestamp'
    })
  }, {
    dataType: 'string',
    field: 'message',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.pipelineInferenceLogs.tableColumn.message', {
      defaultMessage: 'Error message'
    }),
    textOnly: true
  }, {
    dataType: 'number',
    field: 'doc_count',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.pipelineInferenceLogs.tableColumn.docCount', {
      defaultMessage: 'Approx. document count'
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_data_panel.DataPanel, {
    hasBorder: true,
    iconType: "documents",
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.pipelineInferenceLogs.title', {
      defaultMessage: 'Inference errors'
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    tableLayout: "auto",
    columns: errorsColumns,
    items: inferenceErrors,
    rowHeader: "message",
    noItemsMessage: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.pipelineInferenceLogs.emptyMessage', {
      defaultMessage: 'This index has no inference errors'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 11
    }
  })));
};
exports.InferenceErrors = InferenceErrors;