"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.elasticsearchUrl = exports.SearchApplicationAPI = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _cloud_details = require("../../../../shared/cloud_details/cloud_details");
var _doc_links = require("../../../../shared/doc_links");
var _kibana = require("../../../../shared/kibana");
var _search_application_view_logic = require("../search_application_view_logic");
var _generate_search_application_api_key_modal = require("./generate_api_key_modal/generate_search_application_api_key_modal");
var _search_application_api_integration = require("./search_application_api_integration");
var _search_application_api_logic = require("./search_application_api_logic");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/applications/components/search_application/connect/search_application_api.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const elasticsearchUrl = cloudContext => {
  const defaultUrl = 'http://localhost:9200';
  const url = cloudContext.elasticsearchUrl || defaultUrl;
  return url;
};
exports.elasticsearchUrl = elasticsearchUrl;
const SearchApplicationAPI = () => {
  const {
    searchApplicationName
  } = (0, _kea.useValues)(_search_application_view_logic.SearchApplicationViewLogic);
  const {
    isGenerateModalOpen
  } = (0, _kea.useValues)(_search_application_api_logic.SearchApplicationApiLogic);
  const {
    openGenerateModal,
    closeGenerateModal
  } = (0, _kea.useActions)(_search_application_api_logic.SearchApplicationApiLogic);
  const cloudContext = (0, _cloud_details.useCloudDetails)();
  const steps = [{
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.searchApplications.searchApplication.searchApi.step1.setUpSearchtemplate.description",
      defaultMessage: "Your search application uses a {searchTemplateDocLink} to control the types of queries it accepts. Run the following command to view your current search template:",
      values: {
        searchTemplateDocLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _doc_links.docLinks.searchTemplates,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 60,
            columnNumber: 21
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.enterpriseSearch.searchApplications.searchApplication.searchApi.step1.setUpSearchtemplate.searchTemplateDocLink",
          defaultMessage: "search template",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 61,
            columnNumber: 23
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "markup",
      fontSize: "m",
      paddingSize: "m",
      isCopyable: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 15
      }
    }, `GET _application/search_application/${searchApplicationName}/`))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.searchApplications.searchApplication.searchApi.step1.setUpSearchtemplate.warning",
      defaultMessage: "We provide a basic, default search template to get started, but you'll probably want to update it for your use case. Use the examples in our {searchTemplateExampleDoc} for inspiration.",
      values: {
        searchTemplateExampleDoc: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _doc_links.docLinks.searchApplicationsTemplates,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 88,
            columnNumber: 21
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.enterpriseSearch.searchApplications.searchApplication.searchApi.step1.setUpSearchtemplate.warning.searchTemplateExampleDocLink",
          defaultMessage: "documentation",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 89,
            columnNumber: 23
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 15
      }
    })))),
    title: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.searchApi.step1.setUpSearchtemplate.title', {
      defaultMessage: 'Set up your search template'
    })
  }, {
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.searchApplications.searchApplication.searchApi.step2.apiKeyWarning",
      defaultMessage: "This {apiKeyDocumentation} will only be able to access your Search endpoint.",
      values: {
        apiKeyDocumentation: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _doc_links.docLinks.apiKeys,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 118,
            columnNumber: 21
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.enterpriseSearch.searchApplications.searchApplication.searchApi.step2.apiKeyWarning.documentationLink",
          defaultMessage: "API key",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 119,
            columnNumber: 23
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconSide: "left",
      iconType: "plusInCircleFilled",
      onClick: openGenerateModal,
      "data-telemetry-id": "entSearchApplications-searchApi-step2-createApiKeyButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.searchApi.step2.createAPIKeyButton', {
      defaultMessage: 'Create API Key'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconSide: "left",
      iconType: "popout",
      "data-telemetry-id": "entSearchApplications-searchApi-step2-viewKeysButton",
      onClick: () => _kibana.KibanaLogic.values.navigateToUrl('/app/management/security/api_keys', {
        shouldNotCreateHref: true
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.searchApi.step2.viewKeysButton', {
      defaultMessage: 'View Keys'
    }))))),
    title: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.searchApi.step2.title', {
      defaultMessage: 'Generate and save API key'
    })
  }, {
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 179,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.searchApi.step3.copyEndpointDescription', {
      defaultMessage: "Here's the URL for your endpoint:"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 188,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 189,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 190,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "markup",
      fontSize: "m",
      paddingSize: "m",
      isCopyable: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 15
      }
    }, `${elasticsearchUrl(cloudContext)}/_application/search_application/${searchApplicationName}/_search`)))),
    title: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.searchApi.step3.title', {
      defaultMessage: 'Copy your Search endpoint'
    })
  }, {
    children: /*#__PURE__*/_react.default.createElement(_search_application_api_integration.SearchApplicationApiIntegrationStage, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 208,
        columnNumber: 17
      }
    }),
    title: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.searchApi.step4.title', {
      defaultMessage: 'Learn how to call your endpoint'
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isGenerateModalOpen ? /*#__PURE__*/_react.default.createElement(_generate_search_application_api_key_modal.GenerateSearchApplicationApiKeyModal, {
    onClose: closeGenerateModal,
    searchApplicationName: searchApplicationName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 9
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "info",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.searchApplications.searchApplication.searchApi.searchApiCallout.title",
      defaultMessage: "What is Search API?",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 229,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.searchApplication.searchApi.searchApiCallout.body",
    defaultMessage: "The {searchApiDocumentation} allows you to create a secure, public-facing search endpoint for your search application. This endpoint only accepts queries that match the parameters defined in your {searchTemplateDocumenation}.",
    values: {
      searchApiDocumentation: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "search-documentation-link",
        href: _doc_links.docLinks.searchApplicationsSearchApi,
        "data-telemetry-id": "entSearchApplications-searchApi-documentation-viewDocumentaion",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 240,
          columnNumber: 15
        }
      }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.searchApi.searchApiCallout.body.searchApiDocLink', {
        defaultMessage: 'Search API'
      })),
      searchTemplateDocumenation: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "search-template-documentation-link",
        href: _doc_links.docLinks.searchTemplates,
        "data-telemetry-id": "entSearchApplications-searchTemplate-documentation-viewDocumentaion",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 254,
          columnNumber: 15
        }
      }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.searchApi.searchApiCallout.body.searchTemplateDocLink', {
        defaultMessage: 'search template'
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.searchApplication.searchApi.searchApiCallout.searchApiLearnMore",
    defaultMessage: "{searchApiDocumentation}",
    values: {
      searchApiDocumentation: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "search-documentation-link",
        href: _doc_links.docLinks.searchApplicationsSearchApi,
        target: "_blank",
        "data-telemetry-id": "entSearchApplications-searchApi-learnMoreDocumentation-viewDocumentaion",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 275,
          columnNumber: 15
        }
      }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.searchApi.searchApiCallout.body.searchApiDocumentationLink', {
        defaultMessage: 'Learn more about the Search API'
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 292,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    headingElement: "h2",
    steps: steps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 7
    }
  }));
};
exports.SearchApplicationAPI = SearchApplicationAPI;