"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTransforms = getTransforms;
exports.hasTransforms = hasTransforms;
exports.registerTransforms = registerTransforms;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const registry = {};
function registerTransforms(type, getTransformsCallback) {
  if (registry[type]) {
    throw new Error(`Embeddable transforms for type "${type}" are already registered.`);
  }
  registry[type] = getTransformsCallback;
}
async function getTransforms(type) {
  var _registry$type;
  return await ((_registry$type = registry[type]) === null || _registry$type === void 0 ? void 0 : _registry$type.call(registry));
}
function hasTransforms(type) {
  return Boolean(registry[type]);
}