"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddFromLibraryFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/saved-objects-finder-plugin/public");
var _analytics = require("@kbn/analytics");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _kibana_services = require("../kibana_services");
var _registry = require("./registry");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/embeddable/public/add_from_library/add_from_library_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const runAddTelemetry = (parent, savedObject, savedObjectMetaData) => {
  var _usageCollection$repo;
  if (!(0, _presentationPublishing.apiHasType)(parent)) return;
  const type = savedObjectMetaData.getSavedObjectSubType ? savedObjectMetaData.getSavedObjectSubType(savedObject) : savedObjectMetaData.type;
  _kibana_services.usageCollection === null || _kibana_services.usageCollection === void 0 ? void 0 : (_usageCollection$repo = _kibana_services.usageCollection.reportUiCounter) === null || _usageCollection$repo === void 0 ? void 0 : _usageCollection$repo.call(_kibana_services.usageCollection, parent.type, _analytics.METRIC_TYPE.CLICK, `${type}:add`);
};
const AddFromLibraryFlyout = ({
  container,
  modalTitleId
}) => {
  const libraryTypes = (0, _registry.useAddFromLibraryTypes)();
  const onChoose = (0, _react.useCallback)(async (id, type, name, savedObject) => {
    const libraryType = (0, _registry.getAddFromLibraryType)(type);
    if (!libraryType) {
      _kibana_services.core.notifications.toasts.addWarning(_i18n.i18n.translate('embeddableApi.addPanel.typeNotFound', {
        defaultMessage: 'Unable to load type: {type}',
        values: {
          type
        }
      }));
      return;
    }
    libraryType.onAdd(container, savedObject);
    runAddTelemetry(container, savedObject, libraryType.savedObjectMetaData);
  }, [container]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('embeddableApi.addPanel.Title', {
    defaultMessage: 'Add from library'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_public.SavedObjectFinder, {
    id: "embeddableAddPanel",
    services: {
      contentClient: _kibana_services.contentManagement.client,
      savedObjectsTagging: _kibana_services.savedObjectsTaggingOss === null || _kibana_services.savedObjectsTaggingOss === void 0 ? void 0 : _kibana_services.savedObjectsTaggingOss.getTaggingApi(),
      uiSettings: _kibana_services.core.uiSettings
    },
    onChoose: onChoose,
    savedObjectMetaData: libraryTypes,
    showFilter: true,
    noItemsMessage: _i18n.i18n.translate('embeddableApi.addPanel.noMatchingObjectsMessage', {
      defaultMessage: 'No matching objects found.'
    }),
    getTooltipText: item => {
      return item.managed ? _i18n.i18n.translate('embeddableApi.addPanel.managedPanelTooltip', {
        defaultMessage: 'Elastic manages this panel. Adding it to a dashboard unlinks it from the library.'
      }) : undefined;
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  })));
};
exports.AddFromLibraryFlyout = AddFromLibraryFlyout;