"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PostAttackDiscoveryGenerationsDismissResponse = exports.PostAttackDiscoveryGenerationsDismissRequestParams = void 0;
var _zod = require("@kbn/zod");
var _common_attributes = require("../../../../common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Dismiss attack discovery generations API endpoint
 *   version: 2023-10-31
 */

const PostAttackDiscoveryGenerationsDismissRequestParams = exports.PostAttackDiscoveryGenerationsDismissRequestParams = _zod.z.object({
  /**
   * The unique identifier for the Attack discovery generation execution. This UUID is returned when an attack discovery generation is created and can be found in generation responses.
   */
  execution_uuid: _common_attributes.NonEmptyString
});
const PostAttackDiscoveryGenerationsDismissResponse = exports.PostAttackDiscoveryGenerationsDismissResponse = _zod.z.object({
  /**
   * The number of alerts that were sent as context to the LLM for this generation.
   */
  alerts_context_count: _zod.z.number().optional(),
  /**
   * The unique identifier of the connector used to generate the attack discoveries.
   */
  connector_id: _zod.z.string(),
  /**
   * Statistical information about the connector's performance for this user, providing insights into usage patterns and success rates.
   */
  connector_stats: _zod.z.object({
    /**
     * The average duration in nanoseconds for successful generations using this connector by the current user.
     */
    average_successful_duration_nanoseconds: _zod.z.number().optional(),
    /**
     * The total number of Attack discoveries successfully created for this generation
     */
    successful_generations: _zod.z.number().optional()
  }).optional(),
  /**
   * The number of attack discoveries that were generated during this execution.
   */
  discoveries: _zod.z.number(),
  /**
   * The timestamp when the generation process completed, in ISO 8601 format. This field may be absent for generations that haven't finished.
   */
  end: _zod.z.string().optional(),
  /**
   * The unique identifier for this attack discovery generation execution. This UUID can be used to reference this specific generation in other API calls.
   */
  execution_uuid: _zod.z.string(),
  /**
   * A human-readable message describing the current state or progress of the generation process. Provides context about what the AI is analyzing.
   */
  loading_message: _zod.z.string(),
  /**
   * Additional context or reasoning provided when a generation fails or encounters issues. This field helps diagnose problems with the generation process.
   */
  reason: _zod.z.string().optional(),
  /**
   * The timestamp when the generation process began, in ISO 8601 format. This marks the beginning of the AI analysis.
   */
  start: _zod.z.string(),
  /**
   * The current status of the attack discovery generation. After dismissing, this will be set to "dismissed".
   */
  status: _zod.z.enum(['canceled', 'dismissed', 'failed', 'started', 'succeeded'])
});