"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createClassicNavRootProfileProvider = void 0;
var _profiles = require("../../../profiles");
var _accessors = require("./accessors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createClassicNavRootProfileProvider = services => ({
  profileId: 'classic-nav-root-profile',
  profile: {
    getDefaultAdHocDataViews: _accessors.getDefaultAdHocDataViews
  },
  resolve: params => {
    if (typeof params.solutionNavId === 'string') {
      return {
        isMatch: false
      };
    }
    return {
      isMatch: true,
      context: {
        solutionType: _profiles.SolutionType.Default,
        allLogsIndexPattern: services.logsContextService.getAllLogsIndexPattern()
      }
    };
  }
});
exports.createClassicNavRootProfileProvider = createClassicNavRootProfileProvider;