"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentProfilesSection = DocumentProfilesSection;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _profile_section = require("../profile_section");
var _document_profile_table = require("./document_profile_table");
var _get_expand_action = require("./get_expand_action");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/context_awareness/inspector/profiles_inspector_view/document_profiles_section/document_profiles_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function DocumentProfilesSection({
  documentContexts,
  onViewRecordDetails
}) {
  var _documentContexts$exp;
  const [expandedProfileId, setExpandedProfileId] = (0, _react.useState)(undefined);
  const sortedDocumentProfiles = (0, _react.useMemo)(() => {
    return Object.keys(documentContexts !== null && documentContexts !== void 0 ? documentContexts : {}).sort().map(profileId => {
      var _documentContexts$pro, _documentContexts$pro2;
      return {
        profileId,
        recordCount: (_documentContexts$pro = documentContexts === null || documentContexts === void 0 ? void 0 : (_documentContexts$pro2 = documentContexts[profileId]) === null || _documentContexts$pro2 === void 0 ? void 0 : _documentContexts$pro2.length) !== null && _documentContexts$pro !== void 0 ? _documentContexts$pro : 0
      };
    });
  }, [documentContexts]);
  return /*#__PURE__*/_react.default.createElement(_profile_section.ProfileSection, {
    title: _i18n.i18n.translate('discover.inspector.profilesInspectorView.documentProfilesTitle', {
      defaultMessage: 'Document profiles'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    tableCaption: _i18n.i18n.translate('discover.inspector.profilesInspectorView.documentProfilesTableCaption', {
      defaultMessage: 'Document profiles'
    }),
    items: sortedDocumentProfiles,
    itemId: "profileId",
    columns: [{
      field: 'profileId',
      name: _i18n.i18n.translate('discover.inspector.profilesInspectorView.documentProfilesProfileIdColumn', {
        defaultMessage: 'Profile ID'
      })
    }, {
      field: 'recordCount',
      name: _i18n.i18n.translate('discover.inspector.profilesInspectorView.documentProfilesRecordCountColumn', {
        defaultMessage: 'Record count'
      })
    }, {
      name: _i18n.i18n.translate('discover.inspector.profilesInspectorView.documentProfilesRecordExpandColumn', {
        defaultMessage: 'Expand profile'
      }),
      align: 'right',
      actions: [(0, _get_expand_action.getExpandAction)({
        name: _i18n.i18n.translate('discover.inspector.profilesInspectorView.documentProfilesRecordExpandColumn', {
          defaultMessage: 'Expand profile'
        }),
        description: _i18n.i18n.translate('discover.inspector.profilesInspectorView.documentProfilesRecordExpandColumnDescription', {
          defaultMessage: 'Expand to view records for this profile'
        }),
        'data-test-subj': 'documentsProfilesSectionExpandAction',
        isExpanded: ({
          profileId
        }) => expandedProfileId === profileId,
        onClick: value => setExpandedProfileId(value === null || value === void 0 ? void 0 : value.profileId)
      })]
    }],
    itemIdToExpandedRowMap: expandedProfileId ? {
      [expandedProfileId]: /*#__PURE__*/_react.default.createElement(_document_profile_table.DocumentProfileTable, {
        onViewRecordDetails: record => onViewRecordDetails(record),
        profileId: expandedProfileId,
        records: (_documentContexts$exp = documentContexts === null || documentContexts === void 0 ? void 0 : documentContexts[expandedProfileId]) !== null && _documentContexts$exp !== void 0 ? _documentContexts$exp : [],
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 103,
          columnNumber: 19
        }
      })
    } : undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }));
}