"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTopNavBadges = void 0;
var _react = _interopRequireDefault(require("react"));
var _unsavedChangesBadge = require("@kbn/unsaved-changes-badge");
var _managedContentBadge = require("@kbn/managed-content-badge");
var _i18n = require("@kbn/i18n");
var _discoverUtils = require("@kbn/discover-utils");
var _solutions_view_badge = require("./solutions_view_badge");
var _save_discover_session = require("./save_discover_session");
var _redux = require("../../state_management/redux");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/application/main/components/top_nav/get_top_nav_badges.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * Helper function to build the top nav badges
 */
const getTopNavBadges = ({
  hasUnsavedChanges,
  stateContainer,
  services,
  topNavCustomization
}) => {
  var _defaultBadges$unsave;
  const saveDiscoverSession = initialCopyOnSave => (0, _save_discover_session.onSaveDiscoverSession)({
    initialCopyOnSave,
    services,
    state: stateContainer
  });
  const defaultBadges = topNavCustomization === null || topNavCustomization === void 0 ? void 0 : topNavCustomization.defaultBadges;
  const entries = [];
  const isManaged = stateContainer.savedSearchState.getState().managed;
  if (services.spaces) {
    entries.push({
      badgeText: _i18n.i18n.translate('discover.topNav.solutionViewTitle', {
        defaultMessage: 'Check out context-aware Discover'
      }),
      renderCustomBadge: ({
        badgeText
      }) => /*#__PURE__*/_react.default.createElement(_solutions_view_badge.SolutionsViewBadge, {
        badgeText: badgeText,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 54,
          columnNumber: 45
        }
      })
    });
  }
  if (hasUnsavedChanges && !(defaultBadges !== null && defaultBadges !== void 0 && (_defaultBadges$unsave = defaultBadges.unsavedChangesBadge) !== null && _defaultBadges$unsave !== void 0 && _defaultBadges$unsave.disabled)) {
    entries.push((0, _unsavedChangesBadge.getTopNavUnsavedChangesBadge)({
      onRevert: async () => {
        (0, _discoverUtils.dismissFlyouts)([_discoverUtils.DiscoverFlyouts.lensEdit]);
        const {
          persistedDiscoverSession
        } = stateContainer.internalState.getState();
        if (persistedDiscoverSession) {
          await stateContainer.internalState.dispatch(_redux.internalStateActions.resetDiscoverSession()).unwrap();
        }
      },
      onSave: services.capabilities.discover_v2.save && !isManaged ? async () => {
        await saveDiscoverSession();
      } : undefined,
      onSaveAs: services.capabilities.discover_v2.save ? async () => {
        await saveDiscoverSession(true);
      } : undefined
    }));
  }
  if (isManaged) {
    entries.push((0, _managedContentBadge.getManagedContentBadge)(_i18n.i18n.translate('discover.topNav.managedContentLabel', {
      defaultMessage: 'This Discover session is managed by Elastic. Changes here must be saved to a new Discover session.'
    })));
  }
  return entries;
};
exports.getTopNavBadges = getTopNavBadges;