"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoResultsSuggestionWhenQuery = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _syntax_suggestions_popover = require("./syntax_suggestions_popover");
var _use_discover_services = require("../../../../../hooks/use_discover_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/application/main/components/no_results/no_results_suggestions/no_results_suggestion_when_query.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const getExamples = (querySyntax, docLinks) => {
  if (!querySyntax) {
    return null;
  }
  if (querySyntax === 'lucene') {
    return {
      title: _i18n.i18n.translate('discover.noResults.luceneExamples.title', {
        defaultMessage: 'Lucene examples'
      }),
      items: [{
        label: _i18n.i18n.translate('discover.noResults.luceneExamples.findRequestsThatContain200Text', {
          defaultMessage: 'Find requests that contain the number 200, in any field'
        }),
        example: '200'
      }, {
        label: _i18n.i18n.translate('discover.noResults.luceneExamples.find200InStatusFieldText', {
          defaultMessage: 'Find 200 in the status field'
        }),
        example: 'status:200'
      }, {
        label: _i18n.i18n.translate('discover.noResults.luceneExamples.findAllStatusCodesText', {
          defaultMessage: 'Find all status codes between 400-499'
        }),
        example: 'status:[400 TO 499]'
      }, {
        label: _i18n.i18n.translate('discover.noResults.luceneExamples.findStatusCodesWithPHPText', {
          defaultMessage: 'Find status codes 400-499 with the extension php'
        }),
        example: 'status:[400 TO 499] AND extension:PHP'
      }, {
        label: _i18n.i18n.translate('discover.noResults.luceneExamples.findStatusCodesWithPhpOrHtmlText', {
          defaultMessage: 'Find status codes 400-499 with the extension php or html'
        }),
        example: 'status:[400 TO 499] AND (extension:php OR extension:html)'
      }],
      footer: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "discover.noResults.luceneExamples.footerDescription",
        defaultMessage: "Learn more about {luceneLink}",
        values: {
          luceneLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: docLinks.links.query.luceneQuerySyntax,
            target: "_blank",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 77,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "discover.noResults.luceneExamples.footerLuceneLink",
            defaultMessage: "query string syntax",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 78,
              columnNumber: 17
            }
          }))
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 72,
          columnNumber: 9
        }
      })
    };
  }
  if (querySyntax === 'kuery') {
    return {
      title: _i18n.i18n.translate('discover.noResults.kqlExamples.title', {
        defaultMessage: 'KQL examples'
      }),
      items: [{
        label: _i18n.i18n.translate('discover.noResults.kqlExamples.filterForExistingFieldsText', {
          defaultMessage: 'Filter for documents where a field exists'
        }),
        example: 'http.request.method: *'
      }, {
        label: _i18n.i18n.translate('discover.noResults.kqlExamples.filterForDocsThatMatchValueText', {
          defaultMessage: 'Filter for documents that match a value'
        }),
        example: 'http.request.method: GET'
      }, {
        label: _i18n.i18n.translate('discover.noResults.kqlExamples.filterForDocsWithinRangeText', {
          defaultMessage: 'Filter for documents within a range'
        }),
        example: 'http.response.bytes > 10000 and http.response.bytes <= 20000'
      }, {
        label: _i18n.i18n.translate('discover.noResults.kqlExamples.filterForDocsWithWildcardsText', {
          defaultMessage: 'Filter for documents using wildcards'
        }),
        example: 'http.response.status_code: 4*'
      }, {
        label: _i18n.i18n.translate('discover.noResults.kqlExamples.negatingQueryText', {
          defaultMessage: 'Negating a query'
        }),
        example: 'NOT http.request.method: GET'
      }, {
        label: _i18n.i18n.translate('discover.noResults.kqlExamples.combineMultipleText', {
          defaultMessage: 'Combining multiple queries with AND/OR'
        }),
        example: 'http.request.method: GET AND http.response.status_code: 400'
      }, {
        label: _i18n.i18n.translate('discover.noResults.kqlExamples.queryMultipleText', {
          defaultMessage: 'Querying multiple values for the same field'
        }),
        example: 'http.request.method: (GET OR POST OR DELETE)'
      }],
      footer: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "discover.noResults.kqlExamples.kqlDescription",
        defaultMessage: "Learn more about {kqlLink}",
        values: {
          kqlLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: docLinks.links.query.kueryQuerySyntax,
            target: "_blank",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 145,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "discover.noResults.kqlExamples.footerKQLLink",
            defaultMessage: "KQL",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 146,
              columnNumber: 17
            }
          }))
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 140,
          columnNumber: 9
        }
      })
    };
  }
  return null;
};
const NoResultsSuggestionWhenQuery = ({
  querySyntax
}) => {
  const services = (0, _use_discover_services.useDiscoverServices)();
  const {
    docLinks
  } = services;
  const examplesMeta = getExamples(querySyntax, docLinks);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "xs",
    responsive: false,
    wrap: false,
    css: (0, _react2.css)`
          display: inline-flex;
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "discoverNoResultsAdjustSearch",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 11
    }
  }, examplesMeta ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.noResults.suggestion.adjustYourQueryWithExamplesText",
    defaultMessage: "Try a different query",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.noResults.suggestion.adjustYourQueryText",
    defaultMessage: "Adjust your query",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 15
    }
  }))), !!examplesMeta && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_syntax_suggestions_popover.SyntaxSuggestionsPopover, {
    meta: examplesMeta,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 13
    }
  }))));
};
exports.NoResultsSuggestionWhenQuery = NoResultsSuggestionWhenQuery;