"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Failures = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/file_data_visualizer/new/file_status/failures.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PAGE_SIZE = 100;
const containerStyle = (0, _react2.css)({
  maxHeight: '200px',
  overflowY: 'auto'
});
const Failures = ({
  failedDocs,
  docCount
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [page, setPage] = (0, _react.useState)(0);
  const startIndex = page * PAGE_SIZE;
  const endIndex = startIndex + PAGE_SIZE;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.importSummary.documentsCouldNotBeImportedTitle",
      defaultMessage: "Some documents could not be imported",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 9
      }
    }),
    color: "warning",
    iconType: "help",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.importSummary.documentsCouldNotBeImportedDescription",
    defaultMessage: "{importFailuresLength} out of {docCount} documents could not be imported. This could be due to lines not matching the Grok pattern.",
    values: {
      importFailuresLength: failedDocs.length,
      docCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "failureList",
    buttonContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.importSummary.failedDocumentsButtonLabel",
      defaultMessage: "Failed documents",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 11
      }
    }),
    paddingSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: containerStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  }, failedDocs.length > PAGE_SIZE && /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
    pageCount: Math.ceil(failedDocs.length / PAGE_SIZE),
    activePage: page,
    onPageClick: newPage => setPage(newPage),
    compressed: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 13
    }
  }), failedDocs.slice(startIndex, endIndex).map(({
    item,
    reason,
    doc
  }) => /*#__PURE__*/_react.default.createElement("div", {
    key: item,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: {
      color: euiTheme.colors.danger
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 15
    }
  }, item, ": ", reason), /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 15
    }
  }, JSON.stringify(doc)))))));
};
exports.Failures = Failures;