"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataDriftPromptHint = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/data_drift/data_drift_hint.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ANALYZE_DATA_DRIFT_LABEL = _i18n.i18n.translate('xpack.dataVisualizer.dataDrift.analyzeDataDriftLabel', {
  defaultMessage: 'Analyze data drift'
});
const DataDriftPromptHint = ({
  refresh,
  canAnalyzeDataDrift
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    color: "subdued",
    hasShadow: false,
    hasBorder: false,
    css: {
      minWidth: '100%'
    },
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.dataDrift.emptyPromptBody",
      defaultMessage: "The Data Drift Viewer visualizes changes in the model input data, which can lead to model performance degradation over time. Detecting data drifts enables you to identify potential performance issues.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      disabled: !canAnalyzeDataDrift,
      fill: true,
      size: "m",
      onClick: refresh,
      iconType: "visTagCloud",
      "data-test-subj": "runDataDriftAnalysis",
      "aria-label": ANALYZE_DATA_DRIFT_LABEL,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 11
      }
    }, ANALYZE_DATA_DRIFT_LABEL)),
    "data-test-subj": "dataDriftRunAnalysisEmptyPrompt",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 5
    }
  });
};
exports.DataDriftPromptHint = DataDriftPromptHint;