"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getChoroplethTopValuesLayer = exports.ChoroplethMap = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/maps-plugin/common");
var _fieldTypes = require("@kbn/field-types");
var _kibana_context = require("../../../../../kibana_context");
var _expanded_row_panel = require("./expanded_row_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/common/components/stats_table/components/field_data_expanded_row/choropleth_map.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getChoroplethTopValuesLayer = (fieldName, topValues, {
  layerId,
  field
}) => {
  return {
    id: 'choroplethLayer',
    label: _i18n.i18n.translate('xpack.dataVisualizer.choroplethMap.topValuesCount', {
      defaultMessage: 'Top values count for {fieldName}',
      values: {
        fieldName
      }
    }),
    joins: [{
      // Left join is the id from the type of field (e.g. world_countries)
      leftField: field,
      right: {
        id: 'doc_count',
        type: _common.SOURCE_TYPES.TABLE_SOURCE,
        __rows: topValues,
        __columns: [{
          name: 'key',
          type: 'string'
        }, {
          name: 'doc_count',
          type: 'number'
        }],
        // Right join/term is the field in the doc you’re trying to join it to (foreign key - e.g. US)
        term: 'key'
      }
    }],
    sourceDescriptor: {
      type: 'EMS_FILE',
      id: layerId
    },
    style: {
      type: _common.LAYER_STYLE_TYPE.VECTOR,
      // @ts-ignore missing style properties. Remove once 'VectorLayerDescriptor' type is updated
      properties: {
        icon: {
          type: _common.STYLE_TYPE.STATIC,
          options: {
            value: 'marker'
          }
        },
        fillColor: {
          type: _common.STYLE_TYPE.DYNAMIC,
          options: {
            color: 'Blue to Red',
            colorCategory: 'palette_0',
            fieldMetaOptions: {
              isEnabled: true,
              sigma: 3
            },
            type: _common.COLOR_MAP_TYPE.ORDINAL,
            field: {
              name: 'doc_count',
              origin: _common.FIELD_ORIGIN.JOIN
            },
            useCustomColorRamp: false
          }
        },
        lineColor: {
          type: _common.STYLE_TYPE.DYNAMIC,
          options: {
            fieldMetaOptions: {
              isEnabled: true
            }
          }
        },
        lineWidth: {
          type: _common.STYLE_TYPE.STATIC,
          options: {
            size: 1
          }
        }
      },
      isTimeAware: true
    },
    type: _common.LAYER_TYPE.GEOJSON_VECTOR
  };
};
exports.getChoroplethTopValuesLayer = getChoroplethTopValuesLayer;
const ChoroplethMap = ({
  stats,
  suggestion
}) => {
  var _ref, _stats$totalDocuments;
  const {
    services: {
      data: {
        fieldFormats
      },
      maps: mapsService
    }
  } = (0, _kibana_context.useDataVisualizerKibana)();
  const {
    fieldName,
    isTopValuesSampled,
    topValues,
    sampleCount
  } = stats;
  const choroplethLayer = (0, _react.useMemo)(() => getChoroplethTopValuesLayer(fieldName || '', topValues || [], suggestion), [suggestion, fieldName, topValues]);
  const totalDocuments = (_ref = (_stats$totalDocuments = stats.totalDocuments) !== null && _stats$totalDocuments !== void 0 ? _stats$totalDocuments : sampleCount) !== null && _ref !== void 0 ? _ref : 0;
  const countsElement = totalDocuments ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 5
    }
  }, isTopValuesSampled ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.dataGrid.fieldExpandedRow.choroplethMapTopValues.calculatedFromSampleRecordsLabel",
    defaultMessage: "Calculated from {sampledDocumentsFormatted} sample {sampledDocuments, plural, one {record} other {records}}.",
    values: {
      sampledDocuments: sampleCount,
      sampledDocumentsFormatted: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 128,
          columnNumber: 15
        }
      }, fieldFormats.getDefaultInstance(_fieldTypes.KBN_FIELD_TYPES.NUMBER, [_fieldTypes.ES_FIELD_TYPES.INTEGER]).convert(sampleCount))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.dataGrid.fieldExpandedRow.choroplethMapTopValues.calculatedFromTotalRecordsLabel",
    defaultMessage: "Calculated from {totalDocumentsFormatted} {totalDocuments, plural, one {record} other {records}}.",
    values: {
      totalDocuments,
      totalDocumentsFormatted: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 143,
          columnNumber: 15
        }
      }, fieldFormats.getDefaultInstance(_fieldTypes.KBN_FIELD_TYPES.NUMBER, [_fieldTypes.ES_FIELD_TYPES.INTEGER]).convert(totalDocuments !== null && totalDocuments !== void 0 ? totalDocuments : 0))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 9
    }
  })) : null;
  return /*#__PURE__*/_react.default.createElement(_expanded_row_panel.ExpandedRowPanel, {
    dataTestSubj: 'fileDataVisualizerChoroplethMapTopValues',
    className: 'dvPanel__wrapper',
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 5
    }
  }, mapsService && /*#__PURE__*/_react.default.createElement("div", {
    className: 'dvMap__wrapper',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(mapsService.PassiveMap, {
    passiveLayer: choroplethLayer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 11
    }
  })), countsElement);
};
exports.ChoroplethMap = ChoroplethMap;