"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeoPointForm = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/common/components/combined_fields/geo_point.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class GeoPointForm extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "onLatFieldChange", e => {
      this.setState({
        latField: e.target.value
      });
    });
    (0, _defineProperty2.default)(this, "onLonFieldChange", e => {
      this.setState({
        lonField: e.target.value
      });
    });
    (0, _defineProperty2.default)(this, "onGeoPointFieldChange", e => {
      const geoPointField = e.target.value;
      this.setState({
        geoPointField
      });
      this.hasNameCollision(geoPointField);
    });
    (0, _defineProperty2.default)(this, "hasNameCollision", (0, _lodash.debounce)(name => {
      try {
        const geoPointFieldError = this.props.hasNameCollision(name) ? (0, _utils.getNameCollisionMsg)(name) : '';
        this.setState({
          geoPointFieldError
        });
      } catch (error) {
        this.setState({
          submitError: error.message
        });
      }
    }, 200));
    (0, _defineProperty2.default)(this, "onSubmit", () => {
      try {
        const combinedField = (0, _utils.createGeoPointCombinedField)(this.state.latField, this.state.lonField, this.state.geoPointField);
        this.props.addCombinedField(combinedField, mappings => {
          const newMappings = (0, _lodash.cloneDeep)(mappings);
          return (0, _utils.addCombinedFieldsToMappings)(newMappings, [combinedField]);
        }, pipelines => pipelines.map(pipeline => (0, _utils.addCombinedFieldsToPipeline)(pipeline, [combinedField])));
        this.setState({
          submitError: ''
        });
      } catch (error) {
        this.setState({
          submitError: error.message
        });
      }
    });
    const {
      latFields,
      lonFields
    } = (0, _utils.getLatLonFields)(props.results);
    const latOptions = latFields.map(field => ({
      value: field,
      text: field
    }));
    const lonOptions = lonFields.map(field => ({
      value: field,
      text: field
    }));
    this.state = {
      latField: latOptions.length > 0 ? latOptions[0].value : '',
      lonField: lonOptions.length > 0 ? lonOptions[0].value : '',
      geoPointField: '',
      geoPointFieldError: '',
      submitError: '',
      latFields: latOptions,
      lonFields: lonOptions
    };
  }
  render() {
    let error;
    if (this.state.submitError) {
      error = /*#__PURE__*/_react.default.createElement(_eui.EuiFormErrorText, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 128,
          columnNumber: 15
        }
      }, this.state.submitError);
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.dataVisualizer.file.geoPointForm.latFieldLabel', {
        defaultMessage: 'Latitude field'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      options: this.state.latFields,
      value: this.state.latField,
      onChange: this.onLatFieldChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.dataVisualizer.file.geoPointForm.lonFieldLabel', {
        defaultMessage: 'Longitude field'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      options: this.state.lonFields,
      value: this.state.lonField,
      onChange: this.onLonFieldChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.dataVisualizer.file.geoPointForm.geoPointFieldLabel', {
        defaultMessage: 'Geo point field'
      }),
      isInvalid: this.state.geoPointFieldError !== '',
      error: [this.state.geoPointFieldError],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: this.state.geoPointField,
      onChange: this.onGeoPointFieldChange,
      isInvalid: this.state.geoPointFieldError !== '',
      "aria-label": _i18n.i18n.translate('xpack.dataVisualizer.file.geoPointForm.geoPointFieldAriaLabel', {
        defaultMessage: 'Geo point field, required field'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 9
      }
    }), error, /*#__PURE__*/_react.default.createElement(_eui.EuiTextAlign, {
      textAlign: "right",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 180,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      fill: true,
      disabled: !this.state.latField || !this.state.lonField || !this.state.geoPointField || this.state.geoPointFieldError !== '',
      onClick: this.onSubmit,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.geoPointForm.submitButtonLabel",
      defaultMessage: "Add",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 192,
        columnNumber: 13
      }
    }))));
  }
}
exports.GeoPointForm = GeoPointForm;