"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteScritpedFieldConfirmationModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_management/public/components/edit_index_pattern/scripted_fields_table/components/confirmation_modal/confirmation_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const DeleteScritpedFieldConfirmationModal = ({
  field,
  hideDeleteConfirmationModal,
  deleteField
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const title = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.scripted.deleteFieldLabel', {
    defaultMessage: "Delete scripted field ''{fieldName}''?",
    values: {
      fieldName: field.name
    }
  });
  const cancelButtonText = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.scripted.deleteField.cancelButton', {
    defaultMessage: 'Cancel'
  });
  const confirmButtonText = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.scripted.deleteField.deleteButton', {
    defaultMessage: 'Delete'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: title,
    titleProps: {
      id: modalTitleId
    },
    onCancel: hideDeleteConfirmationModal,
    onConfirm: deleteField,
    cancelButtonText: cancelButtonText,
    confirmButtonText: confirmButtonText,
    defaultFocusedButton: _eui.EUI_MODAL_CONFIRM_BUTTON,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  });
};
exports.DeleteScritpedFieldConfirmationModal = DeleteScritpedFieldConfirmationModal;