"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasetQualityLink = void 0;
var _react = _interopRequireDefault(require("react"));
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _use_kibana = require("../../utils/use_kibana");
var _use_date_picker = require("../hooks/use_date_picker");
var _legend_action_item = require("./legend_action_item");
var _translations = require("../../translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_usage/public/app/components/dataset_quality_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DatasetQualityLink = exports.DatasetQualityLink = /*#__PURE__*/_react.default.memo(({
  dataStreamName
}) => {
  const {
    dateRangePickerState
  } = (0, _use_date_picker.useDateRangePicker)();
  const {
    services: {
      share: {
        url
      }
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    startDate,
    endDate
  } = dateRangePickerState;
  const locator = url.locators.get(_deeplinksObservability.DATA_QUALITY_DETAILS_LOCATOR_ID);
  const onClickDataQuality = async () => {
    const locatorParams = {
      dataStream: dataStreamName,
      timeRange: {
        from: startDate,
        to: endDate,
        refresh: {
          pause: true,
          value: 0
        }
      }
    };
    if (locator) {
      await locator.navigate(locatorParams);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_legend_action_item.LegendActionItem, {
    label: _translations.UX_LABELS.dataQualityPopup.view,
    onClick: onClickDataQuality,
    dataTestSubj: "DatasetQualityAction",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  });
});