"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardGrid = void 0;
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _coreRenderingBrowser = require("@kbn/core-rendering-browser");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _gridLayout = require("@kbn/grid-layout");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _constants = require("../../../common/content_management/constants");
var _layout_manager = require("../../dashboard_api/layout_manager");
var _use_dashboard_api = require("../../dashboard_api/use_dashboard_api");
var _use_dashboard_internal_api = require("../../dashboard_api/use_dashboard_internal_api");
var _constants2 = require("./constants");
var _dashboard_grid_item = require("./dashboard_grid_item");
var _use_layout_styles = require("./use_layout_styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/dashboard/public/dashboard_renderer/grid/dashboard_grid.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DashboardGrid = () => {
  const dashboardApi = (0, _use_dashboard_api.useDashboardApi)();
  const dashboardInternalApi = (0, _use_dashboard_internal_api.useDashboardInternalApi)();
  const layoutRef = (0, _react.useRef)(null);
  const layoutStyles = (0, _use_layout_styles.useLayoutStyles)();
  const panelRefs = (0, _react.useRef)({});
  const [topOffset, setTopOffset] = (0, _react.useState)(_constants2.DEFAULT_DASHBOARD_DRAG_TOP_OFFSET);
  const [expandedPanelId, useMargins, viewMode, layout, dashboardContainerRef] = (0, _presentationPublishing.useBatchedPublishingSubjects)(dashboardApi.expandedPanelId$, dashboardApi.settings.useMargins$, dashboardApi.viewMode$, dashboardInternalApi.gridLayout$, dashboardInternalApi.dashboardContainerRef$);
  (0, _react.useEffect)(() => {
    var _dashboardContainerRe;
    const newTopOffset = (_dashboardContainerRe = dashboardContainerRef === null || dashboardContainerRef === void 0 ? void 0 : dashboardContainerRef.getBoundingClientRect().top) !== null && _dashboardContainerRe !== void 0 ? _dashboardContainerRe : _constants2.DEFAULT_DASHBOARD_DRAG_TOP_OFFSET;
    if (newTopOffset !== topOffset) setTopOffset(newTopOffset);
  }, [dashboardContainerRef, topOffset]);
  const appFixedViewport = (0, _coreRenderingBrowser.useAppFixedViewport)();
  const onLayoutChange = (0, _react.useCallback)(newLayout => {
    if (viewMode !== 'edit') return;
    const currLayout = dashboardInternalApi.layout$.getValue();
    const updatedLayout = {
      sections: {},
      panels: {}
    };
    Object.values(newLayout).forEach(widget => {
      if (widget.type === 'section') {
        updatedLayout.sections[widget.id] = {
          collapsed: widget.isCollapsed,
          title: widget.title,
          grid: {
            i: widget.id,
            y: widget.row
          }
        };
        Object.values(widget.panels).forEach(panel => {
          updatedLayout.panels[panel.id] = {
            ...currLayout.panels[panel.id],
            grid: {
              ...convertGridPanelToDashboardGridData(panel),
              sectionId: widget.id
            }
          };
        });
      } else {
        // widget is a panel
        updatedLayout.panels[widget.id] = {
          ...currLayout.panels[widget.id],
          grid: convertGridPanelToDashboardGridData(widget)
        };
      }
    });
    if (!(0, _layout_manager.areLayoutsEqual)(currLayout, updatedLayout)) {
      dashboardInternalApi.layout$.next(updatedLayout);
    }
  }, [dashboardInternalApi.layout$, viewMode]);
  const renderPanelContents = (0, _react.useCallback)((id, setDragHandles) => {
    const panels = dashboardInternalApi.layout$.getValue().panels;
    if (!panels[id]) return;
    if (!panelRefs.current[id]) {
      panelRefs.current[id] = /*#__PURE__*/_react.default.createRef();
    }
    const type = panels[id].type;
    return /*#__PURE__*/_react.default.createElement(_dashboard_grid_item.DashboardGridItem, {
      ref: panelRefs.current[id],
      key: id,
      id: id,
      type: type,
      setDragHandles: setDragHandles,
      appFixedViewport: appFixedViewport,
      "data-grid-row": panels[id].grid.y // initialize data-grid-row
      ,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 9
      }
    });
  }, [appFixedViewport, dashboardInternalApi.layout$]);
  const styles = (0, _use_memo_css.useMemoCss)(dashboardGridStyles);
  (0, _react.useEffect)(() => {
    /**
     * ResizeObserver fires the callback on `.observe()` with the initial size of the observed
     * element; we want to ignore this first call and scroll to the bottom on the **second**
     * callback - i.e. after the row is actually added to the DOM
     */
    let first = false;
    const scrollToBottomOnResize = new ResizeObserver(() => {
      if (first) {
        first = false;
      } else {
        dashboardApi.scrollToBottom();
        scrollToBottomOnResize.disconnect(); // once scrolled, stop observing resize events
      }
    });

    /**
     * When `scrollToBottom$` emits, wait for the `layoutRef` size to change then scroll
     * to the bottom of the screen
     */
    const scrollToBottomSubscription = dashboardApi.scrollToBottom$.subscribe(() => {
      if (!layoutRef.current) return;
      first = true; // ensure that only the second resize callback actually triggers scrolling
      scrollToBottomOnResize.observe(layoutRef.current);
    });
    return () => {
      scrollToBottomOnResize.disconnect();
      scrollToBottomSubscription.unsubscribe();
    };
  }, [dashboardApi]);
  const memoizedGridLayout = (0, _react.useMemo)(() => {
    // memoizing this component reduces the number of times it gets re-rendered to a minimum
    return /*#__PURE__*/_react.default.createElement(_gridLayout.GridLayout, {
      css: layoutStyles,
      layout: layout,
      gridSettings: {
        gutterSize: useMargins ? _constants2.DASHBOARD_MARGIN_SIZE : 0,
        rowHeight: _constants2.DASHBOARD_GRID_HEIGHT,
        columnCount: _constants.DASHBOARD_GRID_COLUMN_COUNT,
        keyboardDragTopLimit: topOffset
      },
      useCustomDragHandle: true,
      renderPanelContents: renderPanelContents,
      onLayoutChange: onLayoutChange,
      expandedPanelId: expandedPanelId,
      accessMode: viewMode === 'edit' ? 'EDIT' : 'VIEW',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 7
      }
    });
  }, [layoutStyles, layout, useMargins, renderPanelContents, onLayoutChange, expandedPanelId, viewMode, topOffset]);
  (0, _react.useEffect)(() => {
    // update `data-grid-row` attribute for all panels because it is used for some styling
    Object.values(layout).forEach(widget => {
      if (widget.type === 'panel') {
        const panelRef = panelRefs.current[widget.id];
        if (typeof panelRef !== 'function' && panelRef !== null && panelRef !== void 0 && panelRef.current) {
          panelRef.current.setAttribute('data-grid-row', `${widget.row}`);
        }
      }
    });
  }, [layout]);
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: layoutRef,
    className: (0, _classnames.default)(viewMode === 'edit' ? 'dshLayout--editing' : 'dshLayout--viewing', {
      'dshLayout-withoutMargins': !useMargins,
      'dshLayout-isMaximizedPanel': expandedPanelId !== undefined
    }),
    css: styles.dashboard,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 5
    }
  }, memoizedGridLayout);
};
exports.DashboardGrid = DashboardGrid;
const convertGridPanelToDashboardGridData = panel => {
  return {
    i: panel.id,
    y: panel.row,
    x: panel.column,
    w: panel.width,
    h: panel.height
  };
};
const dashboardGridStyles = {
  dashboard: ({
    euiTheme
  }) => (0, _react2.css)({
    position: 'relative',
    // for dashboards with no controls, increase the z-index of the hover actions in the
    // top row so that they overlap the sticky nav in Dashboard
    ".dshDashboardViewportWrapper:not(:has(.dshDashboardViewport-controls)) & .dshDashboardGrid__item[data-grid-row='0'] .embPanel__hoverActions": {
      zIndex: euiTheme.levels.toast
    },
    // Hide hover actions when dashboard has an overlay
    '.dshDashboardGrid__item--blurred .embPanel__hoverActions, .dshDashboardGrid__item--focused .embPanel__hoverActions': {
      visibility: 'hidden !important'
    },
    '&.dshLayout-isMaximizedPanel': {
      height: '100%',
      // need to override the kbn-grid-layout height when a single panel is expanded
      '.dshDashboardGrid__item--expanded': {
        position: 'absolute',
        width: '100%'
      },
      [`@media (max-width: ${euiTheme.breakpoint.m}px)`]: {
        // on smaller screens, the maximized panel should take the full height of the screen minus the sticky top nav
        minHeight: 'calc(100vh - var(--kbn-application--sticky-headers-offset, 0px))'
      }
    },
    // LAYOUT MODES
    // Adjust borders/etc... for non-spaced out and expanded panels
    '&.dshLayout-withoutMargins': {
      paddingTop: euiTheme.size.s,
      '.embPanel__content, .embPanel, .embPanel__hoverActionsAnchor, .lnsExpressionRenderer': {
        borderRadius: 0
      },
      '.embPanel__content, .embPanel__header': {
        backgroundColor: euiTheme.colors.backgroundBasePlain
      }
    },
    // drag handle visibility when dashboard is in edit mode or a panel is expanded
    '&.dshLayout-withoutMargins:not(.dshLayout--editing), .dshDashboardGrid__item--expanded, .dshDashboardGrid__item--blurred, .dshDashboardGrid__item--focused': {
      '.embPanel--dragHandle, ~.kbnGridPanel--resizeHandle': {
        visibility: 'hidden'
      }
    }
  })
};