"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MomentService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @internal */
class MomentService {
  constructor() {
    (0, _defineProperty2.default)(this, "uiSettingsSubscription", void 0);
  }
  async setup() {}
  async start({
    uiSettings
  }) {
    const setDefaultTimezone = tz => {
      const zone = _momentTimezone.default.tz.zone(tz);
      if (zone) {
        _momentTimezone.default.tz.setDefault(zone.name);
      } else {
        _momentTimezone.default.tz.setDefault(_momentTimezone.default.tz.guess());
      }
    };
    const setStartDayOfWeek = day => {
      const dow = _momentTimezone.default.weekdays().indexOf(day);
      _momentTimezone.default.updateLocale(_momentTimezone.default.locale(), {
        week: {
          dow
        }
      });
    };
    this.uiSettingsSubscription = (0, _rxjs.merge)(uiSettings.get$('dateFormat:tz').pipe((0, _rxjs.tap)(setDefaultTimezone)), uiSettings.get$('dateFormat:dow').pipe((0, _rxjs.tap)(setStartDayOfWeek))).subscribe();
  }
  async stop() {
    if (this.uiSettingsSubscription) {
      this.uiSettingsSubscription.unsubscribe();
      this.uiSettingsSubscription = undefined;
    }
  }
}
exports.MomentService = MomentService;