"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SideNavPrimaryMenuItem = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _menu_item = require("../menu_item");
var _use_tooltip = require("../../hooks/use_tooltip");
var _beta_badge = require("../beta_badge");
var _constants = require("../../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/navigation/src/components/side_nav/primary_menu_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SideNavPrimaryMenuItem = exports.SideNavPrimaryMenuItem = /*#__PURE__*/(0, _react.forwardRef)(({
  children,
  hasContent,
  href,
  iconType,
  id,
  isHighlighted,
  isCurrent,
  isCollapsed,
  isHorizontal,
  badgeType,
  ...props
}, ref) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    tooltipRef,
    handleMouseOut
  } = (0, _use_tooltip.useTooltip)();
  const wrapperStyles = (0, _react2.css)`
      display: flex;
      justify-content: center;
      width: 100%;
    `;
  const betaContentStyles = (0, _react2.css)`
      display: flex;
      align-items: center;
      gap: ${euiTheme.size.xs};
    `;
  const getLabelWithBeta = label => /*#__PURE__*/_react.default.createElement("div", {
    css: betaContentStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }, label), badgeType && /*#__PURE__*/_react.default.createElement(_beta_badge.BetaBadge, {
    type: badgeType,
    isInverted: !isHorizontal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 23
    }
  }));
  const getTooltipContent = () => {
    if (isHorizontal || hasContent) return null;
    if (isCollapsed) return badgeType ? getLabelWithBeta(children) : children;
    if (!isCollapsed && badgeType) return getLabelWithBeta(badgeType === 'beta' ? _i18n.i18n.translate('core.ui.chrome.sideNavigation.betaTooltipLabel', {
      defaultMessage: 'Beta'
    }) : badgeType === 'techPreview' ? _i18n.i18n.translate('core.ui.chrome.sideNavigation.techPreviewTooltipLabel', {
      defaultMessage: 'Tech preview'
    }) : children);
    return null;
  };
  const menuItemContent = isHorizontal && badgeType ? getLabelWithBeta(children) : children;
  const menuItem = /*#__PURE__*/_react.default.createElement(_menu_item.MenuItem, (0, _extends2.default)({
    "data-test-subj": `sideNavPrimaryMenuItem-${id}`,
    href: href,
    iconType: iconType,
    id: id,
    isCurrent: isCurrent,
    isHighlighted: isHighlighted,
    isHorizontal: isHorizontal,
    isLabelVisible: isHorizontal ? true : !isCollapsed,
    ref: ref
  }, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }), menuItemContent);
  const tooltipContent = getTooltipContent();
  if (tooltipContent) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      ref: tooltipRef,
      anchorProps: {
        css: wrapperStyles
      },
      content: tooltipContent,
      disableScreenReaderOutput: true,
      onMouseOut: handleMouseOut,
      position: "right",
      repositionOnScroll: true,
      offset: _constants.TOOLTIP_OFFSET,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 9
      }
    }, menuItem);
  }
  return menuItem;
});