"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Tour = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/navigation-tour/src/tour.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function TourContent({
  tourManager
}) {
  const state = (0, _useObservable.default)(tourManager.state$);
  if (!state) return null;
  if (state.status === 'idle' || state.status === 'completed' || state.status === 'skipped') return null;
  if (state.status === 'waiting') {
    return /*#__PURE__*/_react.default.createElement(WaitingTour, {
      state: state,
      tourManager: tourManager,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 29,
        columnNumber: 12
      }
    });
  }
  const currentStep = state.steps[state.currentStepIndex];
  if (!currentStep) return null;
  return /*#__PURE__*/_react.default.createElement(ActiveTour, {
    state: state,
    tourManager: tourManager,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 10
    }
  });
}
const Tour = props => {
  return /*#__PURE__*/_react.default.createElement(TourErrorBoundary, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(TourContent, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  })));
};
exports.Tour = Tour;
function ActiveTour({
  state,
  tourManager
}) {
  const currentStep = state.steps[state.currentStepIndex];
  if (!currentStep) return null;
  const isLastStep = state.steps.length === state.currentStepIndex + 1;
  const handleNext = () => {
    tourManager.nextStep();
  };
  const handleSkip = () => {
    tourManager.skipTour();
  };
  const handleFinish = () => {
    tourManager.finishTour();
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
    key: currentStep.id,
    isStepOpen: true,
    title: currentStep.title,
    anchor: currentStep.target,
    onFinish: isLastStep ? handleFinish : handleNext,
    step: state.currentStepIndex + 1,
    stepsTotal: state.steps.length,
    content: currentStep.content,
    anchorPosition: 'leftCenter',
    panelProps: {
      'data-test-subj': `nav-tour-step-${currentStep.id}`
    },
    display: "block",
    footerAction: isLastStep ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      color: "success",
      onClick: handleFinish,
      "data-test-subj": "nav-tour-next-button",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "core.chrome.navigationTour.finishTourButton",
      defaultMessage: "Finish tour",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 13
      }
    })) : [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      color: "text",
      onClick: handleSkip,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "core.chrome.navigationTour.skipTourButton",
      defaultMessage: "Skip tour",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      color: "success",
      onClick: handleNext,
      "data-test-subj": "nav-tour-next-button",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "core.chrome.navigationTour.nextButton",
      defaultMessage: "Next",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 15
      }
    }))],
    minWidth: 300,
    maxWidth: 360,
    repositionOnScroll: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  });
}
function WaitingTour({
  state,
  tourManager
}) {
  (0, _react.useEffect)(() => {
    const pollForVisibleSteps = () => {
      const requiredSteps = state.steps.filter(step => step.required);
      const visibleSteps = state.steps.filter(step => (0, _eui.findElementBySelectorOrRef)(step.target));
      const canStart = requiredSteps.length > 0 ? requiredSteps.every(step => visibleSteps.includes(step)) // All required visible
      : visibleSteps.length > 0; // At least one visible

      if (canStart) {
        const visibleStepIds = visibleSteps.map(step => step.id);
        tourManager.activateTour(visibleStepIds);
        return;
      }

      // Continue polling
      setTimeout(pollForVisibleSteps, 100);
    };

    // Start polling with a small delay to allow DOM to settle
    const timeout = setTimeout(pollForVisibleSteps, 0);

    // Timeout after 10 seconds to prevent infinite waiting
    const maxWaitTimeout = setTimeout(() => {
      tourManager.skipTour();
    }, 10000);
    return () => {
      clearTimeout(timeout);
      clearTimeout(maxWaitTimeout);
    };
  }, [state.steps, tourManager]);
  return null;
}

/**
 * We want to make sure that if the tour crashes for any reason, it doesn't break the whole app.
 * So we use an error boundary to catch any errors and simply don't render the tour in that case.
 */
class TourErrorBoundary extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      hasError: false
    });
  }
  static getDerivedStateFromError() {
    return {
      hasError: true
    };
  }
  render() {
    if (this.state.hasError) return null;
    return this.props.children;
  }
}