"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LayoutDebugOverlay = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _coreChromeLayoutConstants = require("@kbn/core-chrome-layout-constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/layout/core-chrome-layout-components/debug/layout_debug_overlay.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const overlayStyle = (0, _react2.css)`
  pointer-events: none;
  position: fixed;
  inset: 0;
  z-index: ${_coreChromeLayoutConstants.layoutLevels.debug};
`;
const rectStyle = (0, _react2.css)`
  position: absolute;
  border: 2px dashed rgba(0, 153, 255, 0.8);
  background: rgba(0, 153, 255, 0.1);
  color: #0099ff;
  font-size: 12px;
  font-family: monospace;
  display: flex;
  align-items: flex-start;
  justify-content: flex-start;
  pointer-events: none;
`;
const labelStyle = (0, _react2.css)`
  background: rgba(0, 153, 255, 0.85);
  color: white;
  padding: 2px 6px;
  border-radius: 0 0 4px 0;
  font-size: 11px;
  margin: 0;
  pointer-events: none;
`;
const slots = [{
  name: 'banner',
  style: {
    top: (0, _coreChromeLayoutConstants.layoutVar)('banner.top'),
    left: (0, _coreChromeLayoutConstants.layoutVar)('banner.left'),
    right: (0, _coreChromeLayoutConstants.layoutVar)('banner.right'),
    bottom: (0, _coreChromeLayoutConstants.layoutVar)('banner.bottom'),
    width: (0, _coreChromeLayoutConstants.layoutVar)('banner.width'),
    height: (0, _coreChromeLayoutConstants.layoutVar)('banner.height')
  }
}, {
  name: 'header',
  style: {
    top: (0, _coreChromeLayoutConstants.layoutVar)('header.top'),
    bottom: (0, _coreChromeLayoutConstants.layoutVar)('header.bottom'),
    left: (0, _coreChromeLayoutConstants.layoutVar)('header.left'),
    right: (0, _coreChromeLayoutConstants.layoutVar)('header.right'),
    width: (0, _coreChromeLayoutConstants.layoutVar)('header.width'),
    height: (0, _coreChromeLayoutConstants.layoutVar)('header.height')
  }
}, {
  name: 'navigation',
  style: {
    top: (0, _coreChromeLayoutConstants.layoutVar)('navigation.top'),
    bottom: (0, _coreChromeLayoutConstants.layoutVar)('navigation.bottom'),
    left: (0, _coreChromeLayoutConstants.layoutVar)('navigation.left'),
    right: (0, _coreChromeLayoutConstants.layoutVar)('navigation.right'),
    width: (0, _coreChromeLayoutConstants.layoutVar)('navigation.width'),
    height: (0, _coreChromeLayoutConstants.layoutVar)('navigation.height')
  }
}, {
  name: 'sidebar',
  style: {
    top: (0, _coreChromeLayoutConstants.layoutVar)('sidebar.top'),
    bottom: (0, _coreChromeLayoutConstants.layoutVar)('sidebar.bottom'),
    left: (0, _coreChromeLayoutConstants.layoutVar)('sidebar.left'),
    right: (0, _coreChromeLayoutConstants.layoutVar)('sidebar.right'),
    width: (0, _coreChromeLayoutConstants.layoutVar)('sidebar.width'),
    height: (0, _coreChromeLayoutConstants.layoutVar)('sidebar.height')
  }
}, {
  name: 'application',
  style: {
    top: (0, _coreChromeLayoutConstants.layoutVar)('application.top'),
    bottom: (0, _coreChromeLayoutConstants.layoutVar)('application.bottom'),
    left: (0, _coreChromeLayoutConstants.layoutVar)('application.left'),
    right: (0, _coreChromeLayoutConstants.layoutVar)('application.right'),
    width: (0, _coreChromeLayoutConstants.layoutVar)('application.width'),
    height: (0, _coreChromeLayoutConstants.layoutVar)('application.height')
  }
}, {
  name: 'applicationTopBar',
  style: {
    top: (0, _coreChromeLayoutConstants.layoutVar)('application.topBar.top'),
    bottom: (0, _coreChromeLayoutConstants.layoutVar)('application.topBar.bottom'),
    left: (0, _coreChromeLayoutConstants.layoutVar)('application.topBar.left'),
    right: (0, _coreChromeLayoutConstants.layoutVar)('application.topBar.right'),
    width: (0, _coreChromeLayoutConstants.layoutVar)('application.topBar.width'),
    height: (0, _coreChromeLayoutConstants.layoutVar)('application.topBar.height')
  }
}, {
  name: 'footer',
  style: {
    top: (0, _coreChromeLayoutConstants.layoutVar)('footer.top'),
    bottom: (0, _coreChromeLayoutConstants.layoutVar)('footer.bottom'),
    left: (0, _coreChromeLayoutConstants.layoutVar)('footer.left'),
    right: (0, _coreChromeLayoutConstants.layoutVar)('footer.right'),
    width: (0, _coreChromeLayoutConstants.layoutVar)('footer.width'),
    height: (0, _coreChromeLayoutConstants.layoutVar)('footer.height')
  }
}, {
  name: 'applicationBottomBar',
  style: {
    top: (0, _coreChromeLayoutConstants.layoutVar)('application.bottomBar.top'),
    bottom: (0, _coreChromeLayoutConstants.layoutVar)('application.bottomBar.bottom'),
    left: (0, _coreChromeLayoutConstants.layoutVar)('application.bottomBar.left'),
    right: (0, _coreChromeLayoutConstants.layoutVar)('application.bottomBar.right'),
    width: (0, _coreChromeLayoutConstants.layoutVar)('application.bottomBar.width'),
    height: (0, _coreChromeLayoutConstants.layoutVar)('application.bottomBar.height')
  }
}, {
  name: 'applicationContent',
  style: {
    top: (0, _coreChromeLayoutConstants.layoutVar)('application.content.top'),
    left: (0, _coreChromeLayoutConstants.layoutVar)('application.content.left'),
    right: (0, _coreChromeLayoutConstants.layoutVar)('application.content.right'),
    width: (0, _coreChromeLayoutConstants.layoutVar)('application.content.width'),
    height: (0, _coreChromeLayoutConstants.layoutVar)('application.content.height')
  }
}];
const defaultColors = {
  banner: '#0099ff',
  header: '#00bfae',
  navigation: '#c837ab',
  sidebar: '#ffd600',
  application: '#4caf50',
  applicationTopBar: '#1976d2',
  applicationBottomBar: '#e65100',
  applicationContent: '#00bcd4',
  footer: '#7c4dff'
};

/**
 * A debug overlay component that visually outlines the main layout slots (banner, header, navigation, sidebar, etc.)
 * using colored rectangles. This is useful for development and debugging to understand the placement and sizing of layout regions.
 *
 * @param props - {@link LayoutDebugOverlayProps} Optional colors to override the default slot colors.
 * @returns The rendered debug overlay as a fixed-position set of rectangles.
 */
const LayoutDebugOverlay = ({
  colors = {}
}) => {
  const mergedColors = {
    ...defaultColors,
    ...colors
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    css: overlayStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 5
    }
  }, slots.map(slot => {
    const color = mergedColors[slot.name] || Object.values(defaultColors)[0];
    return /*#__PURE__*/_react.default.createElement("div", {
      key: slot.name,
      css: (0, _react2.css)([rectStyle, `
                border-color: ${color};
                background: ${color}1A;
                color: ${color};
              `]),
      style: slot.style,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      css: (0, _react2.css)([labelStyle, `background: ${color};`]),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 187,
        columnNumber: 13
      }
    }, slot.name));
  }));
};
exports.LayoutDebugOverlay = LayoutDebugOverlay;