"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditingColumn = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _inline_editable_table_logic = require("./inline_editable_table_logic");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/content_connectors/public/components/shared/tables/inline_editable_table/editing_column.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EditingColumn = ({
  column,
  isLoading = false
}) => {
  const {
    fieldErrors,
    rowErrors,
    editingItemValue
  } = (0, _kea.useValues)(_inline_editable_table_logic.InlineEditableTableLogic);
  const {
    setEditingItemValue
  } = (0, _kea.useActions)(_inline_editable_table_logic.InlineEditableTableLogic);
  if (!editingItemValue) return null;
  const fieldError = fieldErrors[column.field];
  const isInvalid = !!fieldError || rowErrors.length > 0;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: fieldError && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "danger",
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 11
      }
    }, fieldError),
    isInvalid: isInvalid,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, column.editingRender(editingItemValue,
  // TODO we shouldn't need to cast this?
  newValue => {
    setEditingItemValue({
      ...editingItemValue,
      [column.field]: newValue
    });
  }, {
    isInvalid,
    isLoading
  })));
};
exports.EditingColumn = EditingColumn;