"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConsoleWrapper = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _eui = require("@elastic/eui");
var localStorageObjectClient = _interopRequireWildcard(require("../../../lib/local_storage_object_client"));
var _kb = require("../../../lib/kb");
var _services = require("../../../services");
var _tracker = require("../../../services/tracker");
var _lib = require("../../lib");
var _contexts = require("../../contexts");
var _main = require("../main");
var _components = require("../../components");
var _styles = require("./styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/console/public/application/containers/embeddable/console_wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const loadDependencies = async (core, usageCollection) => {
  const {
    docLinks: {
      DOC_LINK_VERSION,
      links
    },
    http,
    notifications,
    ...startServices
  } = core;
  const trackUiMetric = (0, _tracker.createUsageTracker)(usageCollection);
  trackUiMetric.load('opened_embedded_app');
  await (0, _kb.loadActiveApi)(core.http);
  const autocompleteInfo = (0, _services.getAutocompleteInfo)();
  const storage = (0, _services.getStorage)();
  const history = (0, _services.createHistory)({
    storage
  });
  const settings = (0, _services.createSettings)({
    storage
  });
  const objectStorageClient = localStorageObjectClient.create(storage);
  const api = (0, _lib.createApi)({
    http
  });
  const esHostService = (0, _lib.createEsHostService)({
    api
  });
  autocompleteInfo.mapping.setup(http, settings);
  return {
    ...startServices,
    autocompleteInfo,
    docLinks: links,
    docLinkVersion: DOC_LINK_VERSION,
    esHostService,
    history,
    http,
    notifications,
    objectStorageClient,
    settings,
    storage,
    theme$: startServices.theme.theme$,
    trackUiMetric
  };
};
const useStyles = () => {
  return {
    embeddableConsoleContent: (0, _styles.useEmbeddableConsoleContentStyles)()
  };
};
const ConsoleWrapper = props => {
  const [dependencies, setDependencies] = (0, _react.useState)(null);
  const {
    core,
    dataViews,
    data,
    licensing,
    usageCollection,
    onKeyDown,
    isDevMode,
    isOpen
  } = props;
  const styles = useStyles();
  (0, _react.useEffect)(() => {
    if (dependencies === null && isOpen) {
      loadDependencies(core, usageCollection).then(setDependencies);
    }
  }, [dependencies, setDependencies, core, usageCollection, isOpen]);
  if (!dependencies && !isOpen) {
    // Console has not been opened
    return null;
  }
  if (!dependencies) {
    // Console open for the first time, wait for dependencies to load.
    return /*#__PURE__*/_react.default.createElement(_components.EditorContentSpinner, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 12
      }
    });
  }
  const {
    autocompleteInfo,
    docLinkVersion,
    docLinks,
    esHostService,
    history,
    http,
    notifications,
    objectStorageClient,
    settings,
    storage,
    trackUiMetric,
    ...startServices
  } = dependencies;
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, core, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_contexts.ServicesContextProvider, {
    value: {
      ...startServices,
      docLinkVersion,
      docLinks,
      services: {
        esHostService,
        storage,
        history,
        settings,
        notifications,
        trackUiMetric,
        objectStorageClient,
        http,
        autocompleteInfo,
        application: startServices.application,
        dataViews,
        data,
        licensing
      },
      config: {
        isDevMode
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_contexts.RequestContextProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_contexts.EditorContextProvider, {
    settings: settings.toJSON(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 11
    }
  }, isOpen ? /*#__PURE__*/_react.default.createElement("div", {
    css: styles.embeddableConsoleContent,
    "data-test-subj": "consoleEmbeddedBody",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiWindowEvent, {
    event: "keydown",
    handler: onKeyDown,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_main.Main, {
    isEmbeddable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 17
    }
  })) : /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 15
    }
  })))));
};
exports.ConsoleWrapper = ConsoleWrapper;