"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CategoryFormField = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../common/constants");
var _category_component = require("./category_component");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/category/category_form_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getCategoryConfig = () => ({
  defaultValue: null,
  validations: [{
    validator: ({
      value
    }) => {
      if (value == null) {
        return;
      }
      if ((0, _lodash.isEmpty)(value.trim())) {
        return {
          message: _translations.EMPTY_CATEGORY_VALIDATION_MSG
        };
      }
    }
  }, {
    validator: ({
      value
    }) => {
      if (value == null) {
        return;
      }
      if (value.length > _constants.MAX_CATEGORY_LENGTH) {
        return {
          message: (0, _translations.MAX_LENGTH_ERROR)('category', _constants.MAX_CATEGORY_LENGTH)
        };
      }
    }
  }]
});
const CategoryFormFieldComponent = ({
  isLoading,
  availableCategories,
  formRowProps
}) => {
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "category",
    config: getCategoryConfig(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 5
    }
  }, field => {
    const {
      isInvalid,
      errorMessage
    } = (0, _hook_form_lib.getFieldValidityAndErrorMessage)(field);
    const onChange = category => {
      field.setValue(category);
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({}, formRowProps, {
      label: _translations.CATEGORY,
      error: errorMessage,
      isInvalid: isInvalid,
      "data-test-subj": "caseCategory",
      fullWidth: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_category_component.CategoryComponent, {
      isLoading: isLoading,
      onChange: onChange,
      category: field.value,
      availableCategories: availableCategories,
      isInvalid: isInvalid,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 13
      }
    }));
  });
};
CategoryFormFieldComponent.displayName = 'CategoryFormFieldComponent';
const CategoryFormField = exports.CategoryFormField = /*#__PURE__*/(0, _react.memo)(CategoryFormFieldComponent);