"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InteractionBoundary = void 0;
var _react = _interopRequireWildcard(require("react"));
var _workpad_app = require("../../workpad_app");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/workpad_page/workpad_interactive_page/interaction_boundary.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// This adds a bit of a buffer to make room for scroll bars, etc.
const BUFFER = 24;

/**
 * The `InteractionBoundary` is a simple area which expands beyond the boundaries
 * of the `InteractiveWorkpadPage` to the corners of the `WorkpadApp`, allowing
 * mouse events started outside to fire and be tracked within.
 */
class InteractionBoundary extends _react.PureComponent {
  // Implemented with state, as I think there'll be cases where we want to
  // re-evaluate the size of the interaction boundary in the future.
  constructor() {
    super();
    this.state = {
      height: '0',
      width: '0',
      marginLeft: '0',
      marginTop: '0'
    };
  }
  componentDidMount() {
    const container = $('#' + _workpad_app.WORKPAD_CONTAINER_ID);
    const height = container.height();
    const width = container.width();
    if (height && width) {
      this.setState({
        height: height - BUFFER + 'px',
        width: width - BUFFER + 'px',
        marginLeft: -((width - BUFFER) / 2) + 'px',
        marginTop: -((height - BUFFER) / 2) + 'px'
      });
    }
  }
  render() {
    const style = {
      top: '50%',
      left: '50%',
      position: 'absolute',
      ...this.state
    };
    return /*#__PURE__*/_react.default.createElement("div", {
      id: "canvasInteractionBoundary",
      style: style,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 12
      }
    });
  }
}
exports.InteractionBoundary = InteractionBoundary;