"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShareMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _workpad = require("../../../state/selectors/workpad");
var _hooks = require("../../hooks");
var _share_menu = require("./share_menu.component");
var _utils = require("./utils");
var _kibana_services = require("../../../services/kibana_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/workpad_header/share_menu/share_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const strings = {
  getUnknownExportErrorMessage: type => _i18n.i18n.translate('xpack.canvas.workpadHeaderShareMenu.unknownExportErrorMessage', {
    defaultMessage: 'Unknown export type: {type}',
    values: {
      type
    }
  })
};
const ShareMenu = () => {
  const downloadWorkpad = (0, _hooks.useDownloadWorkpad)();
  const {
    workpad,
    pageCount
  } = (0, _reactRedux.useSelector)(state => ({
    workpad: (0, _workpad.getWorkpad)(state),
    pageCount: (0, _workpad.getPages)(state).length
  }));
  const sharingData = {
    workpad,
    pageCount
  };
  const ReportingComponent = _kibana_services.reportingService ? ({
    onClose
  }) => {
    const ReportingPanelPDFV2 = _kibana_services.reportingService.components.ReportingPanelPDFV2;
    return /*#__PURE__*/_react.default.createElement(ReportingPanelPDFV2, {
      getJobParams: () => (0, _utils.getPdfJobParams)(sharingData, _kibana_services.kibanaVersion),
      layoutOption: "canvas",
      onClose: onClose,
      objectId: workpad.id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 11
      }
    });
  } : null;
  const onExport = (0, _react.useCallback)(type => {
    switch (type) {
      case 'pdf':
        // notifications are automatically handled by the Reporting plugin
        break;
      case 'json':
        downloadWorkpad(workpad.id);
        return;
      default:
        throw new Error(strings.getUnknownExportErrorMessage(type));
    }
  }, [downloadWorkpad, workpad]);
  return /*#__PURE__*/_react.default.createElement(_share_menu.ShareMenu, {
    ReportingComponent,
    onExport,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 10
    }
  });
};
exports.ShareMenu = ShareMenu;