"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Toolbar = void 0;
var _reactRedux = require("react-redux");
var _app = require("../../state/selectors/app");
var _workpad = require("../../state/selectors/workpad");
var _toolbar = require("./toolbar.component");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Toolbar = exports.Toolbar = (0, _reactRedux.connect)(state => ({
  workpadName: (0, _workpad.getWorkpadName)(state),
  workpadId: (0, _workpad.getWorkpad)(state).id,
  totalPages: (0, _workpad.getWorkpad)(state).pages.length,
  selectedPageNumber: (0, _workpad.getSelectedPageIndex)(state) + 1,
  selectedElement: (0, _workpad.getSelectedElement)(state),
  isWriteable: (0, _workpad.isWriteable)(state) && (0, _app.canUserWrite)(state)
}))(_toolbar.Toolbar);