"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FontPicker = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _fonts = require("../../../common/lib/fonts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/font_picker/font_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FontPicker = ({
  value,
  onSelect
}) => {
  // While fonts are strongly-typed, we also support custom fonts someone might type in.
  // So let's cast the fonts and allow for additions.
  const displayedFonts = _fonts.fonts;
  if (value && !_fonts.fonts.find(font => font.value === value)) {
    const label = (value.indexOf(',') >= 0 ? value.split(',')[0] : value).replace(/['"]/g, '');
    displayedFonts.push({
      value,
      label
    });
    displayedFonts.sort((a, b) => a.label.localeCompare(b.label));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    compressed: true,
    options: displayedFonts.map(font => ({
      value: font.value,
      inputDisplay: /*#__PURE__*/_react.default.createElement("div", {
        style: {
          fontFamily: font.value
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 42,
          columnNumber: 23
        }
      }, font.label)
    })),
    valueOfSelected: value,
    onChange: newValue => onSelect && onSelect(newValue),
    "aria-label": _i18n.i18n.translate('xpack.canvas.fontPicker.fontFamilyAriaLabel', {
      defaultMessage: 'Font family'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  });
};
exports.FontPicker = FontPicker;
FontPicker.propTypes = {
  /** Function to execute when a Font is selected. */
  onSelect: _propTypes.default.func,
  /** Initial value of the Font Picker. */
  value: _propTypes.default.string
};
FontPicker.displayName = 'FontPicker';