"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Expression = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _monaco = require("@kbn/monaco");
var _reactShortcuts = require("react-shortcuts");
var _expression_input = require("../expression_input");
var _tool_tip_shortcut = require("../tool_tip_shortcut");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/expression/expression.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// @ts-expect-error
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const strings = {
  getCancelButtonLabel: () => _i18n.i18n.translate('xpack.canvas.expression.cancelButtonLabel', {
    defaultMessage: 'Cancel'
  }),
  getCloseButtonLabel: () => _i18n.i18n.translate('xpack.canvas.expression.closeButtonLabel', {
    defaultMessage: 'Close'
  }),
  getLearnLinkText: () => _i18n.i18n.translate('xpack.canvas.expression.learnLinkText', {
    defaultMessage: 'Learn expression syntax'
  }),
  getMaximizeButtonLabel: () => _i18n.i18n.translate('xpack.canvas.expression.maximizeButtonLabel', {
    defaultMessage: 'Maximize editor'
  }),
  getMinimizeButtonLabel: () => _i18n.i18n.translate('xpack.canvas.expression.minimizeButtonLabel', {
    defaultMessage: 'Minimize Editor'
  }),
  getRunButtonLabel: () => _i18n.i18n.translate('xpack.canvas.expression.runButtonLabel', {
    defaultMessage: 'Run'
  }),
  getRunTooltip: () => _i18n.i18n.translate('xpack.canvas.expression.runTooltip', {
    defaultMessage: 'Run the expression'
  })
};
const shortcut = (ref, cmd, callback) => /*#__PURE__*/_react.default.createElement(_reactShortcuts.Shortcuts, {
  name: "EXPRESSION",
  handler: command => {
    const isInputActive = ref.current && ref.current && ref.current.hasTextFocus();
    if (isInputActive && command === cmd) {
      callback();
    }
  },
  targetNodeSelector: "body",
  global: true,
  stopPropagation: true,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 68,
    columnNumber: 3
  }
});
const Expression = ({
  functionDefinitions,
  formState,
  updateValue,
  setExpression,
  done,
  error,
  isCompact,
  toggleCompactView
}) => {
  const refExpressionInput = (0, _react.useRef)(null);
  const handleRun = () => {
    setExpression(formState.expression);
    // If fullScreen and you hit run, toggle back down so you can see your work
    if (!isCompact && !error) {
      toggleCompactView();
    }
  };
  const onEditorDidMount = editor => {
    /*
      To enable the CMD+ENTER keybinding, which is running the expression,
      it is necessary to disable the `-editor.action.insertLineAfter`,
      which has the same keybinding in the Monaco editor.
      The only available way is adding the empty dynamic keybinding
      (by using private monaco API, proposed by the monaco team), which is bubbling the event.
    */
    // @ts-expect-error
    editor === null || editor === void 0 ? void 0 : editor._standaloneKeybindingService.addDynamicKeybinding('-editor.action.insertLineAfter',
    // eslint-disable-next-line no-bitwise
    _monaco.monaco.KeyMod.CtrlCmd | _monaco.monaco.KeyCode.Enter, () => {});
  };
  const expressionPanel = /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    className: `canvasTray__panel canvasTray__panel--holdingExpression canvasExpression--${isCompact ? 'compactSize' : 'fullSize'}`,
    paddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 5
    }
  }, shortcut(refExpressionInput, 'RUN', () => {
    if (!error) {
      setExpression(formState.expression);
    }
  }), /*#__PURE__*/_react.default.createElement(_expression_input.ExpressionInput, {
    isCompact: isCompact,
    expressionFunctions: functionDefinitions,
    error: error ? error : `\u00A0`,
    expression: formState.expression,
    onChange: updateValue,
    onEditorDidMount: onEditorDidMount,
    editorRef: refExpressionInput,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasExpression__settings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 161,
        columnNumber: 21
      }
    }, strings.getRunTooltip(), ' ', /*#__PURE__*/_react.default.createElement(_tool_tip_shortcut.ToolTipShortcut, {
      namespace: "EXPRESSION",
      action: "RUN",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 23
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    disabled: !!error,
    onClick: handleRun,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 19
    }
  }, strings.getRunButtonLabel()))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    color: formState.dirty ? 'danger' : 'primary',
    onClick: done,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 17
    }
  }, formState.dirty ? strings.getCancelButtonLabel() : strings.getCloseButtonLabel())))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: "https://www.elastic.co/guide/en/kibana/current/canvas-function-reference.html",
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 17
    }
  }, strings.getLearnLinkText())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "fullScreen",
    onClick: toggleCompactView,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 17
    }
  }, isCompact ? strings.getMaximizeButtonLabel() : strings.getMinimizeButtonLabel())))))));
  if (isCompact) {
    return expressionPanel;
  } else {
    // Portal is required to show above the navigation
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 209,
        columnNumber: 12
      }
    }, expressionPanel);
  }
};
exports.Expression = Expression;
Expression.propTypes = {
  functionDefinitions: _propTypes.default.array,
  formState: _propTypes.default.object,
  updateValue: _propTypes.default.func,
  setExpression: _propTypes.default.func,
  done: _propTypes.default.func,
  error: _propTypes.default.string
};