"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ArgAddPopover = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _popover = require("../popover");
var _arg_add = require("../arg_add");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/arg_add_popover/arg_add_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const strings = {
  getAddAriaLabel: () => _i18n.i18n.translate('xpack.canvas.argAddPopover.addAriaLabel', {
    defaultMessage: 'Add argument'
  })
};
const ArgAddPopover = ({
  options
}) => {
  const button = handleClick => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "plusInCircle",
    "aria-label": strings.getAddAriaLabel(),
    onClick: handleClick,
    className: "canvasArg__addArg",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_popover.Popover, {
    id: "arg-add-popover",
    panelClassName: "canvasArg__addPopover",
    panelPaddingSize: "none",
    button: button,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  }, ({
    closePopover
  }) => options.map(opt => {
    var _opt$displayName, _opt$help;
    return /*#__PURE__*/_react.default.createElement(_arg_add.ArgAdd, {
      key: `${opt.name}-add`,
      displayName: (_opt$displayName = opt.displayName) !== null && _opt$displayName !== void 0 ? _opt$displayName : '',
      help: (_opt$help = opt.help) !== null && _opt$help !== void 0 ? _opt$help : '',
      onValueAdd: () => {
        opt.onValueAdd();
        closePopover();
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 11
      }
    });
  }));
};
exports.ArgAddPopover = ArgAddPopover;
ArgAddPopover.propTypes = {
  options: _propTypes.default.array.isRequired
};