"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Banner = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _sharedUxMarkdown = require("@kbn/shared-ux-markdown");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/banners/public/components/banner.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const Banner = ({
  bannerConfig
}) => {
  const {
    textContent,
    textColor,
    linkColor,
    backgroundColor
  } = bannerConfig;
  const customLinkColor = linkColor || 'inherit';
  const bannerStyle = (0, _react2.css)({
    height: '100%',
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
    fontSize: (0, _eui.useEuiFontSize)('s').fontSize,
    backgroundColor,
    color: textColor,
    '& a': {
      color: customLinkColor
    }
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    css: bannerStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-textTruncate",
    "data-test-subj": "bannerInnerWrapper",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxMarkdown.Markdown, {
    readOnly: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 9
    }
  }, textContent)));
};
exports.Banner = Banner;