"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateIntegrationUpload = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _public = require("@kbn/kibana-react-plugin/public");
var _success_section = require("../../../common/components/success_section");
var _section_wrapper = require("../../../common/components/section_wrapper");
var _buttons_footer = require("../../../common/components/buttons_footer");
var _integration_image_header = require("../../../common/components/integration_image_header");
var _common = require("../../../common");
var _use_navigate = require("../../../common/hooks/use_navigate");
var _telemetry = require("../telemetry");
var _docs_link_subtitle = require("./docs_link_subtitle");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/automatic_import/public/components/create_integration/create_integration_upload/create_integration_upload.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CreateIntegrationUpload = exports.CreateIntegrationUpload = /*#__PURE__*/_react.default.memo(() => {
  const telemetry = (0, _telemetry.useTelemetry)();
  const navigate = (0, _use_navigate.useNavigate)();
  const {
    http
  } = (0, _public.useKibana)().services;
  const [file, setFile] = (0, _react.useState)();
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [error, setError] = (0, _react.useState)();
  const [integrationName, setIntegrationName] = (0, _react.useState)();
  const onBack = (0, _react.useCallback)(() => {
    navigate(_use_navigate.Page.landing);
  }, [navigate]);
  const onChangeFile = (0, _react.useCallback)(files => {
    setFile(files === null || files === void 0 ? void 0 : files[0]);
    setError(undefined);
  }, []);
  const onConfirm = (0, _react.useCallback)(() => {
    if (http == null || file == null) {
      return;
    }
    setIsLoading(true);
    const abortController = new AbortController();
    (async () => {
      try {
        const deps = {
          http,
          abortSignal: abortController.signal
        };
        const response = await (0, _common.runInstallPackage)(file, deps);
        const integrationNameFromResponse = (0, _common.getIntegrationNameFromResponse)(response);
        if (integrationNameFromResponse) {
          telemetry.reportUploadZipIntegrationComplete({
            integrationName: integrationNameFromResponse
          });
          setIntegrationName(integrationNameFromResponse);
        } else {
          throw new Error('Integration name not found in response');
        }
      } catch (e) {
        if (!abortController.signal.aborted) {
          var _e$body$message, _e$body;
          const errorMessage = (_e$body$message = (_e$body = e.body) === null || _e$body === void 0 ? void 0 : _e$body.message) !== null && _e$body$message !== void 0 ? _e$body$message : e.message;
          telemetry.reportUploadZipIntegrationComplete({
            error: errorMessage
          });
          setError(`${i18n.UPLOAD_ERROR}: ${errorMessage}`);
        }
      } finally {
        setIsLoading(false);
      }
    })();
  }, [file, http, telemetry, setIntegrationName, setError]);
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_integration_image_header.IntegrationImageHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }), integrationName ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_success_section.SuccessSection, {
    integrationName: integrationName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_buttons_footer.ButtonsFooter, {
    cancelButtonText: i18n.CLOSE_BUTTON,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 11
    }
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_section_wrapper.SectionWrapper, {
    title: i18n.UPLOAD_TITLE,
    subtitle: /*#__PURE__*/_react.default.createElement(_docs_link_subtitle.DocsLinkSubtitle, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 65
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    justifyContent: "center",
    gutterSize: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
    id: "logsSampleFilePicker",
    initialPromptText: i18n.UPLOAD_INPUT_TEXT,
    onChange: onChangeFile,
    display: "large",
    "aria-label": "Upload .zip file",
    accept: "application/zip",
    isLoading: isLoading,
    fullWidth: true,
    isInvalid: error != null,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 19
    }
  }), error && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "danger",
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 21
    }
  }, error))))), /*#__PURE__*/_react.default.createElement(_buttons_footer.ButtonsFooter, {
    isNextDisabled: file == null,
    nextButtonText: i18n.INSTALL_BUTTON,
    onBack: onBack,
    onNext: onConfirm,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 11
    }
  })));
});
CreateIntegrationUpload.displayName = 'CreateIntegrationUpload';