"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isInfraTabHidden = isInfraTabHidden;
exports.isMetricsTabHidden = isMetricsTabHidden;
exports.useTabs = useTabs;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _agent_name = require("../../../../../common/agent_name");
var _apm_feature_flags = require("../../../../../common/apm_feature_flags");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _use_apm_service_context = require("../../../../context/apm_service/use_apm_service_context");
var _use_apm_feature_flag = require("../../../../hooks/use_apm_feature_flag");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_apm_router = require("../../../../hooks/use_apm_router");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_profiling_integration_setting = require("../../../../hooks/use_profiling_integration_setting");
var _use_time_range = require("../../../../hooks/use_time_range");
var _get_alerting_capabilities = require("../../../alerting/utils/get_alerting_capabilities");
var _beta_badge = require("../../../shared/beta_badge");
var _technical_preview_badge = require("../../../shared/technical_preview_badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/routing/templates/apm_service_template/use_tabs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const apmOrderedTabs = ['overview', 'transactions', 'dependencies', 'errors', 'metrics', 'infrastructure', 'service-map', 'logs', 'alerts', 'profiling', 'dashboards'];
function isMetricsTabHidden({
  agentName,
  serverlessType
}) {
  if ((0, _agent_name.isAWSLambdaAgentName)(serverlessType)) {
    return false;
  }
  return !agentName || (0, _agent_name.isRumAgentName)(agentName) || (0, _agent_name.isAzureFunctionsAgentName)(serverlessType);
}
function isInfraTabHidden({
  agentName,
  serverlessType,
  isInfraTabAvailable
}) {
  return !agentName || (0, _agent_name.isRumAgentName)(agentName) || (0, _agent_name.isServerlessAgentName)(serverlessType) || !isInfraTabAvailable;
}
function useTabs({
  selectedTab
}) {
  const router = (0, _use_apm_router.useApmRouter)();
  const {
    agentName,
    serverlessType
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const {
    core,
    plugins
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    capabilities
  } = core.application;
  const {
    isAlertingAvailable,
    canReadAlerts
  } = (0, _get_alerting_capabilities.getAlertingCapabilities)(plugins, capabilities);
  const isInfraTabAvailable = (0, _use_apm_feature_flag.useApmFeatureFlag)(_apm_feature_flags.ApmFeatureFlagName.InfrastructureTabAvailable);
  const isProfilingPluginEnabled = (0, _use_profiling_integration_setting.useProfilingPluginSetting)();
  const {
    path: {
      serviceName
    },
    query: queryFromUrl
  } = (0, _use_apm_params.useApmParams)(`/services/{serviceName}/${selectedTab}`);
  const query = (0, _lodash.omit)(queryFromUrl, 'page', 'pageSize', 'sortField', 'sortDirection');
  const {
    rangeFrom,
    rangeTo,
    environment
  } = queryFromUrl;
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    data: serviceAlertsCount = {
      alertsCount: 0
    }
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/services/{serviceName}/alerts_count', {
      params: {
        path: {
          serviceName
        },
        query: {
          start,
          end,
          environment
        }
      }
    });
  }, [serviceName, start, end, environment]);
  const allTabsDefinitions = [{
    key: 'overview',
    href: router.link('/services/{serviceName}/overview', {
      path: {
        serviceName
      },
      query
    }),
    label: _i18n.i18n.translate('xpack.apm.serviceDetails.overviewTabLabel', {
      defaultMessage: 'Overview'
    })
  }, {
    key: 'transactions',
    href: router.link('/services/{serviceName}/transactions', {
      path: {
        serviceName
      },
      query
    }),
    label: _i18n.i18n.translate('xpack.apm.serviceDetails.transactionsTabLabel', {
      defaultMessage: 'Transactions'
    })
  }, {
    key: 'dependencies',
    href: router.link('/services/{serviceName}/dependencies', {
      path: {
        serviceName
      },
      query
    }),
    label: _i18n.i18n.translate('xpack.apm.serviceDetails.dependenciesTabLabel', {
      defaultMessage: 'Dependencies'
    }),
    hidden: !agentName || (0, _agent_name.isRumAgentName)(agentName)
  }, {
    key: 'errors',
    href: router.link('/services/{serviceName}/errors', {
      path: {
        serviceName
      },
      query
    }),
    label: _i18n.i18n.translate('xpack.apm.serviceDetails.errorsTabLabel', {
      defaultMessage: 'Errors'
    })
  }, {
    key: 'metrics',
    href: router.link('/services/{serviceName}/metrics', {
      path: {
        serviceName
      },
      query
    }),
    label: _i18n.i18n.translate('xpack.apm.serviceDetails.metricsTabLabel', {
      defaultMessage: 'Metrics'
    }),
    append: (0, _agent_name.isServerlessAgentName)(serverlessType) && /*#__PURE__*/_react.default.createElement(_technical_preview_badge.TechnicalPreviewBadge, {
      icon: "beaker",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 56
      }
    }),
    hidden: isMetricsTabHidden({
      agentName,
      serverlessType
    })
  }, {
    key: 'infrastructure',
    href: router.link('/services/{serviceName}/infrastructure', {
      path: {
        serviceName
      },
      query
    }),
    append: /*#__PURE__*/_react.default.createElement(_beta_badge.BetaBadge, {
      icon: "beta",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 193,
        columnNumber: 15
      }
    }),
    label: _i18n.i18n.translate('xpack.apm.home.infraTabLabel', {
      defaultMessage: 'Infrastructure'
    }),
    hidden: isInfraTabHidden({
      agentName,
      serverlessType,
      isInfraTabAvailable
    })
  }, {
    key: 'service-map',
    href: router.link('/services/{serviceName}/service-map', {
      path: {
        serviceName
      },
      query
    }),
    label: _i18n.i18n.translate('xpack.apm.home.serviceMapTabLabel', {
      defaultMessage: 'Service map'
    })
  }, {
    key: 'logs',
    href: router.link('/services/{serviceName}/logs', {
      path: {
        serviceName
      },
      query
    }),
    label: _i18n.i18n.translate('xpack.apm.home.serviceLogsTabLabel', {
      defaultMessage: 'Logs'
    }),
    append: (0, _agent_name.isServerlessAgentName)(serverlessType) && /*#__PURE__*/_react.default.createElement(_technical_preview_badge.TechnicalPreviewBadge, {
      icon: "beaker",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 222,
        columnNumber: 56
      }
    }),
    hidden: !agentName || (0, _agent_name.isRumAgentName)(agentName) || (0, _agent_name.isAzureFunctionsAgentName)(serverlessType)
  }, {
    key: 'alerts',
    href: router.link('/services/{serviceName}/alerts', {
      path: {
        serviceName
      },
      query
    }),
    append: serviceAlertsCount.alertsCount > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "bottom",
      content: _i18n.i18n.translate('xpack.apm.home.serviceAlertsTable.tooltip.activeAlertsExplanation', {
        defaultMessage: 'Active alerts'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 233,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "danger",
      tabIndex: 0,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 242,
        columnNumber: 13
      }
    }, serviceAlertsCount.alertsCount)) : null,
    label: _i18n.i18n.translate('xpack.apm.home.alertsTabLabel', {
      defaultMessage: 'Alerts'
    }),
    hidden: !(isAlertingAvailable && canReadAlerts)
  }, {
    key: 'profiling',
    href: router.link('/services/{serviceName}/profiling', {
      path: {
        serviceName
      },
      query
    }),
    label: _i18n.i18n.translate('xpack.apm.home.profilingTabLabel', {
      defaultMessage: 'Universal Profiling'
    }),
    hidden: !isProfilingPluginEnabled || (0, _agent_name.isRumOrMobileAgentName)(agentName) || (0, _agent_name.isAWSLambdaAgentName)(serverlessType)
  }, {
    key: 'dashboards',
    href: router.link('/services/{serviceName}/dashboards', {
      path: {
        serviceName
      },
      query
    }),
    label: _i18n.i18n.translate('xpack.apm.home.dashboardsTabLabel', {
      defaultMessage: 'Dashboards'
    }),
    append: /*#__PURE__*/_react.default.createElement(_technical_preview_badge.TechnicalPreviewBadge, {
      icon: "beaker",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 276,
        columnNumber: 15
      }
    })
  }];
  const tabsGroupedByKey = (0, _lodash.keyBy)(allTabsDefinitions, 'key');
  return apmOrderedTabs.map(key => tabsGroupedByKey[key]).filter(t => !t.hidden).map(({
    href,
    key,
    label,
    prepend,
    append
  }) => ({
    href,
    label,
    prepend,
    append,
    isSelected: key === selectedTab,
    'data-test-subj': `${key}Tab`
  }));
}