"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApmServiceWrapper = ApmServiceWrapper;
var _react = _interopRequireDefault(require("react"));
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_apm_router = require("../../../hooks/use_apm_router");
var _home = require("../home");
var _use_breadcrumb = require("../../../context/breadcrumbs/use_breadcrumb");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/routing/service_detail/apm_service_wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ApmServiceWrapper() {
  const {
    path: {
      serviceName
    },
    query
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}');
  const router = (0, _use_apm_router.useApmRouter)();
  (0, _use_breadcrumb.useBreadcrumb)(() => [{
    title: _home.ServiceInventoryTitle,
    href: router.link('/services', {
      query
    })
  }, {
    title: serviceName,
    href: router.link('/services/{serviceName}', {
      query,
      path: {
        serviceName
      }
    })
  }], [query, router, serviceName], {
    omitRootOnServerless: true
  });
  return /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.Outlet, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 10
    }
  });
}