"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceOverviewThroughputChart = ServiceOverviewThroughputChart;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _use_previous_period_text = require("../../../../hooks/use_previous_period_text");
var _get_comparison_options = require("../../../shared/time_comparison/get_comparison_options");
var _apm_ml_detectors = require("../../../../../common/anomaly_detection/apm_ml_detectors");
var _formatters = require("../../../../../common/utils/formatters");
var _use_apm_service_context = require("../../../../context/apm_service/use_apm_service_context");
var _use_environments_context = require("../../../../context/environments_context/use_environments_context");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_preferred_service_anomaly_timeseries = require("../../../../hooks/use_preferred_service_anomaly_timeseries");
var _use_time_range = require("../../../../hooks/use_time_range");
var _timeseries_chart_with_context = require("../../../shared/charts/timeseries_chart_with_context");
var _get_comparison_chart_theme = require("../../../shared/time_comparison/get_comparison_chart_theme");
var _get_timeseries_color = require("../../../shared/charts/helper/get_timeseries_color");
var _use_preferred_data_source_and_bucket_size = require("../../../../hooks/use_preferred_data_source_and_bucket_size");
var _document_type = require("../../../../../common/document_type");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _get_throughput_screen_context = require("./get_throughput_screen_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/service_overview/service_overview_throughput_chart/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const INITIAL_STATE = {
  currentPeriod: [],
  previousPeriod: []
};
function ServiceOverviewThroughputChart({
  height,
  kuery,
  transactionName
}) {
  var _data$currentPeriod, _data$previousPeriod, _useApmPluginContext$;
  const {
    query: {
      rangeFrom,
      rangeTo,
      comparisonEnabled,
      offset
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}', '/mobile-services/{serviceName}');
  const {
    environment
  } = (0, _use_environments_context.useEnvironmentsContext)();
  const preferredAnomalyTimeseries = (0, _use_preferred_service_anomaly_timeseries.usePreferredServiceAnomalyTimeseries)(_apm_ml_detectors.AnomalyDetectorType.txThroughput);
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const preferred = (0, _use_preferred_data_source_and_bucket_size.usePreferredDataSourceAndBucketSize)({
    start,
    end,
    numBuckets: 100,
    kuery,
    type: transactionName ? _document_type.ApmDocumentType.TransactionMetric : _document_type.ApmDocumentType.ServiceTransactionMetric
  });
  const {
    transactionType,
    serviceName,
    transactionTypeStatus
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const comparisonChartTheme = (0, _get_comparison_chart_theme.getComparisonChartTheme)();
  const {
    data = INITIAL_STATE,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (!transactionType && transactionTypeStatus === _use_fetcher.FETCH_STATUS.SUCCESS) {
      return Promise.resolve(INITIAL_STATE);
    }
    if (serviceName && transactionType && start && end && preferred) {
      return callApmApi('GET /internal/apm/services/{serviceName}/throughput', {
        params: {
          path: {
            serviceName
          },
          query: {
            environment,
            kuery,
            start,
            end,
            transactionType,
            offset: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? offset : undefined,
            transactionName,
            documentType: preferred.source.documentType,
            rollupInterval: preferred.source.rollupInterval,
            bucketSizeInSeconds: preferred.bucketSizeInSeconds
          }
        }
      });
    }
  }, [environment, kuery, serviceName, start, end, transactionType, transactionTypeStatus, offset, transactionName, comparisonEnabled, preferred]);
  const {
    currentPeriodColor,
    previousPeriodColor
  } = (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.THROUGHPUT);
  const previousPeriodLabel = (0, _use_previous_period_text.usePreviousPeriodLabel)();
  const timeseries = [{
    data: (_data$currentPeriod = data === null || data === void 0 ? void 0 : data.currentPeriod) !== null && _data$currentPeriod !== void 0 ? _data$currentPeriod : [],
    type: 'linemark',
    color: currentPeriodColor,
    title: _i18n.i18n.translate('xpack.apm.serviceOverview.throughtputChartTitle', {
      defaultMessage: 'Throughput'
    })
  }, ...(comparisonEnabled ? [{
    data: (_data$previousPeriod = data === null || data === void 0 ? void 0 : data.previousPeriod) !== null && _data$previousPeriod !== void 0 ? _data$previousPeriod : [],
    type: 'area',
    color: previousPeriodColor,
    title: previousPeriodLabel
  }] : [])];
  const setScreenContext = (_useApmPluginContext$ = (0, _use_apm_plugin_context.useApmPluginContext)().observabilityAIAssistant) === null || _useApmPluginContext$ === void 0 ? void 0 : _useApmPluginContext$.service.setScreenContext;
  (0, _react.useEffect)(() => {
    return setScreenContext === null || setScreenContext === void 0 ? void 0 : setScreenContext((0, _get_throughput_screen_context.getThroughputScreenContext)({
      serviceName,
      transactionName,
      transactionType,
      environment,
      preferred
    }));
  }, [serviceName, transactionName, transactionType, environment, setScreenContext, preferred, start, end]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.apm.serviceOverview.throughtputChartTitle', {
    defaultMessage: 'Throughput'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _i18n.i18n.translate('xpack.apm.serviceOverview.tpmHelp', {
      defaultMessage: 'Throughput is measured in transactions per minute (tpm).'
    }),
    position: "right",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_timeseries_chart_with_context.TimeseriesChartWithContext, {
    id: "throughput",
    height: height,
    showAnnotations: false,
    fetchStatus: status,
    timeseries: timeseries,
    yLabelFormat: _formatters.asExactTransactionRate,
    customTheme: comparisonChartTheme,
    anomalyTimeseries: preferredAnomalyTimeseries ? {
      ...preferredAnomalyTimeseries,
      color: previousPeriodColor
    } : undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 7
    }
  }));
}